/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.smtp;

import java.io.File;
import java.util.Arrays;
import org.springframework.beans.factory.BeanFactory;
import org.tiogasolutions.dev.domain.comm.AuthenticationMethod;
import org.tiogasolutions.notify.kernel.processor.HtmlMessage;
import org.tiogasolutions.notify.kernel.processor.ProcessorType;
import org.tiogasolutions.notify.kernel.processor.TaskProcessor;
import org.tiogasolutions.notify.kernel.processor.ThymeleafMessageBuilder;
import org.tiogasolutions.notify.processor.smtp.EmailMessage;
import org.tiogasolutions.notify.processor.smtp.SmtpAuthType;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.Task;
import org.tiogasolutions.notify.pub.TaskResponse;
import org.tiogasolutions.notify.pub.route.ArgValueMap;

public class SmtpTaskProcessor
implements TaskProcessor {
    private static final ProcessorType PROCESSOR_TYPE = new ProcessorType("smtp");
    private final ThymeleafMessageBuilder messageBuilder = new ThymeleafMessageBuilder();

    public boolean isReady() {
        return true;
    }

    public TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        ArgValueMap argMap = task.getDestination().getArgValueMap();
        String templatePath = this.messageBuilder.getEmailTemplatePath(argMap, "templatePath");
        HtmlMessage htmlMessage = this.messageBuilder.createHtmlMessage(domainProfile, notification, task, templatePath);
        EmailMessage emailMessage = this.createEmailMessage(argMap);
        emailMessage.send(htmlMessage.getSubject(), null, htmlMessage.getBody(), new File[0]);
        return TaskResponse.complete((String)"Email sent");
    }

    protected EmailMessage createEmailMessage(ArgValueMap argMap) {
        SmtpAuthType authType = (SmtpAuthType)((Object)argMap.asEnum(SmtpAuthType.class, "smtpAuthType"));
        String host = argMap.asString("smtpHost");
        String port = argMap.asString("smtpPort");
        String username = argMap.asString("smtpUsername");
        String password = argMap.asString("smtpPassword");
        String from = argMap.asString("smtpFrom");
        String recipient = argMap.asString("smtpRecipients");
        EmailMessage message = new EmailMessage(host, port, Arrays.asList(recipient));
        message.setFrom(from);
        if (authType.isTls()) {
            message.setAuthentication(AuthenticationMethod.TLS, username, password);
        } else if (authType.isSsl()) {
            message.setAuthentication(AuthenticationMethod.SSL, username, password);
        } else {
            message.setAuthentication(AuthenticationMethod.NONE, username, password);
        }
        return message;
    }

    public ProcessorType getType() {
        return PROCESSOR_TYPE;
    }

    public void init(BeanFactory beanFactory) {
    }
}

