/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.dom.AbstractTextNode;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.GroupNode;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMSelector
implements Serializable {
    private static final long serialVersionUID = -1680336779267140369L;
    private static final String TEXT_SELECTOR = "text()";
    private static final String ID_MODIFIER_SEPARATOR = "#";
    private static final String CLASS_MODIFIER_SEPARATOR = ".";
    private static final String REFERENCE_MODIFIER_SEPARATOR = "%";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String selectorPatternStr = "^(/{1,2})([^/\\s]*?)(\\[(?:.*)\\])?$";
    private static final Pattern selectorPattern = Pattern.compile("^(/{1,2})([^/\\s]*?)(\\[(?:.*)\\])?$");
    private static final String modifiersPatternStr = "^(?:\\[(.*?)\\])(\\[(?:.*)\\])?$";
    private static final Pattern modifiersPattern = Pattern.compile("^(?:\\[(.*?)\\])(\\[(?:.*)\\])?$");
    private final String selectorExpression;
    private final boolean descendMoreThanOneLevel;
    private final String selectorPath;
    private final String normalizedSelectorPath;
    private final String selectorPathIdModifier;
    private final String selectorPathClassModifier;
    private final String selectorPathReferenceModifier;
    private final boolean text;
    private List<AttributeCondition> attributes = null;
    private Integer index = null;
    private final DOMSelector next;

    public DOMSelector(String selectorExpression) {
        this(selectorExpression, true);
    }

    private DOMSelector(String selectorExpression, boolean atRootLevel) {
        int firstNonSlash;
        this.selectorExpression = selectorExpression;
        String selectorSpecStr = selectorExpression.trim();
        if (atRootLevel && !selectorSpecStr.startsWith("/")) {
            selectorSpecStr = "//" + selectorSpecStr;
        }
        int selectorSpecStrLen = selectorSpecStr.length();
        for (firstNonSlash = 0; firstNonSlash < selectorSpecStrLen && selectorSpecStr.charAt(firstNonSlash) == '/'; ++firstNonSlash) {
        }
        if (firstNonSlash >= selectorSpecStrLen) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": '/' should be followed by " + "further selector specification");
        }
        int selEnd = selectorSpecStr.substring(firstNonSlash).indexOf(47);
        if (selEnd != -1) {
            String tail = selectorSpecStr.substring(firstNonSlash).substring(selEnd);
            selectorSpecStr = selectorSpecStr.substring(0, firstNonSlash + selEnd);
            this.next = new DOMSelector(tail, false);
        } else {
            this.next = null;
        }
        Matcher matcher = selectorPattern.matcher(selectorSpecStr);
        if (!matcher.matches()) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": selector does not match selector syntax: " + "((/|//)?selector)?([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        String rootGroup = matcher.group(1);
        String selectorNameGroup = matcher.group(2);
        String modifiersGroup = matcher.group(3);
        if (rootGroup == null) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": selector does not match selector syntax: " + "((/|//)?selector)?([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        if ("//".equals(rootGroup)) {
            this.descendMoreThanOneLevel = true;
        } else if ("/".equals(rootGroup)) {
            this.descendMoreThanOneLevel = false;
        } else {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": selector does not match selector syntax: " + "((/|//)?selector)?([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        if (selectorNameGroup == null) {
            throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": selector does not match selector syntax: " + "((/|//)?selector)?([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
        }
        String path = selectorNameGroup;
        int idModifierPos = path.indexOf(ID_MODIFIER_SEPARATOR);
        int classModifierPos = path.indexOf(CLASS_MODIFIER_SEPARATOR);
        int referenceModifierPos = path.indexOf(REFERENCE_MODIFIER_SEPARATOR);
        if (idModifierPos != -1) {
            if (classModifierPos != -1 || referenceModifierPos != -1) {
                throw new TemplateProcessingException("More than one modifier (id, class, reference) have been specified at DOM selector expression \"" + this.selectorExpression + "\", which is forbidden.");
            }
            this.selectorPathIdModifier = path.substring(idModifierPos + ID_MODIFIER_SEPARATOR.length());
            path = path.substring(0, idModifierPos);
            if (StringUtils.isEmptyOrWhitespace(this.selectorPathIdModifier)) {
                throw new TemplateProcessingException("Empty id modifier in DOM selector expression \"" + this.selectorExpression + "\", which is forbidden.");
            }
        } else {
            this.selectorPathIdModifier = null;
        }
        if (classModifierPos != -1) {
            if (idModifierPos != -1 || referenceModifierPos != -1) {
                throw new TemplateProcessingException("More than one modifier (id, class, reference) have been specified at DOM selector expression \"" + this.selectorExpression + "\", which is forbidden.");
            }
            this.selectorPathClassModifier = path.substring(classModifierPos + CLASS_MODIFIER_SEPARATOR.length());
            path = path.substring(0, classModifierPos);
            if (StringUtils.isEmptyOrWhitespace(this.selectorPathClassModifier)) {
                throw new TemplateProcessingException("Empty id modifier in DOM selector expression \"" + this.selectorExpression + "\", which is forbidden.");
            }
        } else {
            this.selectorPathClassModifier = null;
        }
        if (referenceModifierPos != -1) {
            if (idModifierPos != -1 || classModifierPos != -1) {
                throw new TemplateProcessingException("More than one modifier (id, class, reference) have been specified at DOM selector expression \"" + this.selectorExpression + "\", which is forbidden.");
            }
            this.selectorPathReferenceModifier = path.substring(referenceModifierPos + REFERENCE_MODIFIER_SEPARATOR.length());
            path = path.substring(0, referenceModifierPos);
            if (StringUtils.isEmptyOrWhitespace(this.selectorPathReferenceModifier)) {
                throw new TemplateProcessingException("Empty id modifier in DOM selector expression \"" + this.selectorExpression + "\", which is forbidden.");
            }
        } else {
            this.selectorPathReferenceModifier = null;
        }
        this.selectorPath = path;
        this.normalizedSelectorPath = Element.normalizeElementName(this.selectorPath);
        this.text = TEXT_SELECTOR.equals(this.normalizedSelectorPath);
        if (modifiersGroup != null) {
            String remainingModifiers = modifiersGroup;
            while (remainingModifiers != null) {
                Matcher modifiersMatcher = modifiersPattern.matcher(remainingModifiers);
                if (!modifiersMatcher.matches()) {
                    throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": selector does not match selector syntax: " + "((/|//)?selector)?([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
                }
                String currentModifier = modifiersMatcher.group(1);
                remainingModifiers = modifiersMatcher.group(2);
                Integer modifierAsIndex = DOMSelector.parseIndex(currentModifier);
                if (modifierAsIndex != null) {
                    this.index = modifierAsIndex;
                    if (remainingModifiers == null) continue;
                    throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": selector does not match selector syntax: " + "((/|//)?selector)?([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
                }
                List<AttributeCondition> attribs = DOMSelector.parseAttributes(selectorExpression, currentModifier);
                if (attribs == null) {
                    throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": selector does not match selector syntax: " + "(/|//)(selector)([@attrib=\"value\" (and @attrib2=\"value\")?])?([index])?");
                }
                if (this.attributes == null) {
                    this.attributes = attribs;
                    continue;
                }
                this.attributes.addAll(attribs);
            }
            if (this.descendMoreThanOneLevel && this.index != null) {
                throw new TemplateProcessingException("Invalid syntax in DOM selector \"" + selectorExpression + "\": index cannot be specified on a \"descend any levels\" selector (//).");
            }
        }
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    private static Integer parseIndex(String indexGroup) {
        if ("last()".equals(indexGroup.toLowerCase())) {
            return -1;
        }
        try {
            return Integer.valueOf(indexGroup);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static List<AttributeCondition> parseAttributes(String selectorSpec, String indexGroup) {
        ArrayList<AttributeCondition> attributes = new ArrayList<AttributeCondition>(3);
        DOMSelector.parseAttributes(selectorSpec, attributes, indexGroup);
        return attributes;
    }

    private static void parseAttributes(String selectorSpec, List<AttributeCondition> attributes, String indexGroup) {
        String att = null;
        int andPos = indexGroup.indexOf(" and ");
        if (andPos != -1) {
            att = indexGroup.substring(0, andPos);
            String tail = indexGroup.substring(andPos + 5);
            DOMSelector.parseAttributes(selectorSpec, attributes, tail);
        } else {
            att = indexGroup;
        }
        DOMSelector.parseAttribute(selectorSpec, attributes, att);
    }

    private static void parseAttribute(String selectorSpec, List<AttributeCondition> attributes, String attributeSpec) {
        String[] fragments = AttributeCondition.Operator.extractOperator(attributeSpec);
        if (fragments[1] != null) {
            String attrName = fragments[0];
            AttributeCondition.Operator operator = AttributeCondition.Operator.parse(fragments[1]);
            String attrValue = fragments[2];
            if (attrName.startsWith("@")) {
                attrName = attrName.substring(1);
            }
            if (!(attrValue.startsWith("\"") && attrValue.endsWith("\"") || attrValue.startsWith("'") && attrValue.endsWith("'"))) {
                throw new TemplateProcessingException("Invalid syntax in DOM selector: \"" + selectorSpec + "\"");
            }
            attributes.add(new AttributeCondition(Attribute.normalizeAttributeName(attrName), operator, attrValue.substring(1, attrValue.length() - 1)));
        } else {
            String attrName = fragments[0];
            if (attrName.startsWith("@")) {
                attrName = attrName.substring(1);
            }
            attributes.add(new AttributeCondition(Attribute.normalizeAttributeName(attrName), null, null));
        }
    }

    public List<Node> select(Node node) {
        Validate.notNull(node, "Node to be searched cannot be null");
        return this.select(Collections.singletonList(node), null);
    }

    public List<Node> select(Node node, INodeReferenceChecker referenceChecker) {
        Validate.notNull(node, "Node to be searched cannot be null");
        return this.select(Collections.singletonList(node), referenceChecker);
    }

    public List<Node> select(List<Node> nodes) {
        return this.select(nodes, null);
    }

    public List<Node> select(List<Node> nodes, INodeReferenceChecker referenceChecker) {
        Validate.notEmpty(nodes, "Nodes to be searched cannot be null or empty");
        if (nodes.size() == 1 && nodes.get(0) instanceof Document) {
            ArrayList<Node> selected = new ArrayList<Node>(10);
            for (Node node : nodes) {
                this.doCheckNodeSelection(selected, node, referenceChecker);
            }
            return selected;
        }
        ArrayList<ArrayList<Node>> selected = new ArrayList<ArrayList<Node>>(10);
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            ArrayList<Node> arrayList = new ArrayList<Node>(10);
            Node node = iterator.next();
            if (!this.doCheckNodeSelection(arrayList, node, referenceChecker)) continue;
            selected.add(arrayList);
        }
        if (selected.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> selectedNodes = new ArrayList<Node>(10);
        if (this.index == null) {
            for (List list : selected) {
                selectedNodes.addAll(list);
            }
            return selectedNodes;
        }
        if (this.index == -1) {
            selectedNodes.addAll((Collection)selected.get(selected.size() - 1));
            return selectedNodes;
        }
        if (this.index >= selected.size()) {
            return Collections.emptyList();
        }
        selectedNodes.addAll((Collection)selected.get(this.index));
        return selectedNodes;
    }

    private boolean checkChildrenSelection(List<Node> selectedNodes, Node node, INodeReferenceChecker referenceChecker) {
        if (node instanceof NestableNode) {
            ArrayList<ArrayList<Node>> selectedNodesForChildren = new ArrayList<ArrayList<Node>>(10);
            NestableNode nestableNode = (NestableNode)node;
            if (nestableNode.hasChildren()) {
                Iterator<Node> iterator = nestableNode.getChildren().iterator();
                while (iterator.hasNext()) {
                    ArrayList<Node> childSelectedNodes = new ArrayList<Node>(10);
                    Node node2 = iterator.next();
                    if (!this.doCheckNodeSelection(childSelectedNodes, node2, referenceChecker)) continue;
                    selectedNodesForChildren.add(childSelectedNodes);
                }
            }
            if (selectedNodesForChildren.size() == 0) {
                return false;
            }
            if (this.index == null) {
                for (List list : selectedNodesForChildren) {
                    selectedNodes.addAll(list);
                }
                return true;
            }
            if (this.index == -1) {
                selectedNodes.addAll((Collection)selectedNodesForChildren.get(selectedNodesForChildren.size() - 1));
                return true;
            }
            if (this.index >= selectedNodesForChildren.size()) {
                return false;
            }
            selectedNodes.addAll((Collection)selectedNodesForChildren.get(this.index));
            return true;
        }
        return false;
    }

    private boolean doCheckNodeSelection(List<Node> selectedNodes, Node node, INodeReferenceChecker referenceChecker) {
        NestableNode nestableNode;
        if (!this.doCheckSpecificNodeSelection(node, referenceChecker)) {
            NestableNode nestableNode2;
            if ((this.descendMoreThanOneLevel || node instanceof Document || node instanceof GroupNode) && node instanceof NestableNode && (nestableNode2 = (NestableNode)node).hasChildren()) {
                return this.checkChildrenSelection(selectedNodes, node, referenceChecker);
            }
            return false;
        }
        if (this.next == null) {
            selectedNodes.add(node);
            return true;
        }
        if (node instanceof NestableNode && (nestableNode = (NestableNode)node).hasChildren()) {
            if (this.next.checkChildrenSelection(selectedNodes, node, referenceChecker)) {
                return true;
            }
            return this.checkChildrenSelection(selectedNodes, node, referenceChecker);
        }
        return false;
    }

    private boolean doCheckSpecificNodeSelection(Node node, INodeReferenceChecker referenceChecker) {
        if (node instanceof Element) {
            Element element = (Element)node;
            if (this.selectorPathIdModifier != null ? !this.checkPathWithIdModifier(element) : (this.selectorPathClassModifier != null ? !this.checkPathWithClassModifier(element) : (this.selectorPathReferenceModifier != null ? !this.checkPathWithReferenceModifier(element, referenceChecker) : !this.checkPathWithoutModifiers(element, referenceChecker)))) {
                return false;
            }
            if (this.attributes == null || this.attributes.size() == 0) {
                return true;
            }
            for (AttributeCondition attributeCondition : this.attributes) {
                String selectedAttributeName = attributeCondition.getName();
                boolean selectedAttributeMultipe = CLASS_ATTRIBUTE_NAME.equals(selectedAttributeName);
                if (DOMSelector.checkAttributeValue(element, selectedAttributeName, attributeCondition.getOperator(), attributeCondition.getValue(), selectedAttributeMultipe)) continue;
                return false;
            }
            return true;
        }
        if (node instanceof AbstractTextNode) {
            if (referenceChecker != null) {
                return this.text && (this.selectorPathReferenceModifier == null || referenceChecker.checkReference(node, this.selectorPathReferenceModifier));
            }
            return this.text;
        }
        return false;
    }

    private static boolean checkAttributeValue(NestableAttributeHolderNode node, String attributeName, AttributeCondition.Operator operator, String attributeValue, boolean multivalued) {
        if (!node.hasNormalizedAttribute(attributeName)) {
            if (attributeValue == null) {
                return operator == AttributeCondition.Operator.EQUALS;
            }
            return operator == AttributeCondition.Operator.NOT_EQUALS;
        }
        String nodeAttributeValue = node.getAttributeValueFromNormalizedName(attributeName);
        if (nodeAttributeValue == null) {
            if (attributeValue == null) {
                return operator == AttributeCondition.Operator.EQUALS;
            }
            return operator == AttributeCondition.Operator.NOT_EQUALS;
        }
        if (attributeValue == null) {
            return operator == AttributeCondition.Operator.NOT_EQUALS;
        }
        if (!multivalued) {
            switch (operator) {
                case EQUALS: {
                    return nodeAttributeValue.equals(attributeValue);
                }
                case NOT_EQUALS: {
                    return !nodeAttributeValue.equals(attributeValue);
                }
                case STARTS_WITH: {
                    return nodeAttributeValue.startsWith(attributeValue);
                }
                case ENDS_WITH: {
                    return nodeAttributeValue.endsWith(attributeValue);
                }
            }
        }
        if (!(operator != AttributeCondition.Operator.EQUALS && operator != AttributeCondition.Operator.NOT_EQUALS || nodeAttributeValue.contains(attributeValue))) {
            return operator == AttributeCondition.Operator.NOT_EQUALS;
        }
        StringTokenizer nodeAttrValueTokenizer = new StringTokenizer(nodeAttributeValue, ", ");
        while (nodeAttrValueTokenizer.hasMoreTokens()) {
            String nodeAttrValueToken = nodeAttrValueTokenizer.nextToken();
            switch (operator) {
                case EQUALS: {
                    if (!nodeAttrValueToken.equals(attributeValue)) break;
                    return true;
                }
                case NOT_EQUALS: {
                    if (nodeAttrValueToken.equals(attributeValue)) break;
                    return true;
                }
                case STARTS_WITH: {
                    if (!nodeAttrValueToken.startsWith(attributeValue)) break;
                    return true;
                }
                case ENDS_WITH: {
                    if (!nodeAttrValueToken.endsWith(attributeValue)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkPathWithIdModifier(Element element) {
        if (this.selectorPathIdModifier == null) {
            return false;
        }
        String elementName = element.getNormalizedName();
        if (!StringUtils.isEmptyOrWhitespace(this.normalizedSelectorPath) && !this.normalizedSelectorPath.equals(elementName)) {
            return false;
        }
        return DOMSelector.checkAttributeValue(element, ID_ATTRIBUTE_NAME, AttributeCondition.Operator.EQUALS, this.selectorPathIdModifier, false);
    }

    private boolean checkPathWithClassModifier(Element element) {
        if (this.selectorPathClassModifier == null) {
            return false;
        }
        String elementName = element.getNormalizedName();
        if (!StringUtils.isEmptyOrWhitespace(this.normalizedSelectorPath) && !this.normalizedSelectorPath.equals(elementName)) {
            return false;
        }
        return DOMSelector.checkAttributeValue(element, CLASS_ATTRIBUTE_NAME, AttributeCondition.Operator.EQUALS, this.selectorPathClassModifier, true);
    }

    private boolean checkPathWithReferenceModifier(Element element, INodeReferenceChecker referenceChecker) {
        if (this.selectorPathReferenceModifier == null || referenceChecker == null) {
            return false;
        }
        String elementName = element.getNormalizedName();
        if (!StringUtils.isEmptyOrWhitespace(this.normalizedSelectorPath) && !this.normalizedSelectorPath.equals(elementName)) {
            return false;
        }
        return referenceChecker.checkReference(element, this.selectorPathReferenceModifier);
    }

    private boolean checkPathWithoutModifiers(Element element, INodeReferenceChecker referenceChecker) {
        String elementName = element.getNormalizedName();
        if (!StringUtils.isEmptyOrWhitespace(this.selectorPath) && !this.normalizedSelectorPath.equals(elementName)) {
            if (referenceChecker == null) {
                return false;
            }
            return referenceChecker.checkReference(element, this.selectorPath);
        }
        return true;
    }

    public String toString() {
        return this.selectorExpression;
    }

    public static final class AggregatingNodeReferenceChecker
    extends AbstractNodeReferenceChecker {
        private final INodeReferenceChecker one;
        private final INodeReferenceChecker two;

        public AggregatingNodeReferenceChecker(INodeReferenceChecker one, INodeReferenceChecker two) {
            Validate.notNull(one, "Reference checker one cannot be null");
            Validate.notNull(two, "Reference checker two cannot be null");
            this.one = one;
            this.two = two;
        }

        public boolean checkReference(Node node, String referenceValue) {
            if (this.one.checkReference(node, referenceValue)) {
                return true;
            }
            return this.two.checkReference(node, referenceValue);
        }
    }

    public static abstract class AbstractNodeReferenceChecker
    implements INodeReferenceChecker {
        protected AbstractNodeReferenceChecker() {
        }
    }

    public static interface INodeReferenceChecker {
        public boolean checkReference(Node var1, String var2);
    }

    private static final class AttributeCondition {
        private final String name;
        private final Operator operator;
        private final String value;

        AttributeCondition(String name, Operator operator, String value) {
            this.name = name;
            this.operator = operator;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        Operator getOperator() {
            return this.operator;
        }

        String getValue() {
            return this.value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Operator {
            EQUALS,
            NOT_EQUALS,
            STARTS_WITH,
            ENDS_WITH;


            static Operator parse(String operatorStr) {
                if (operatorStr == null) {
                    return null;
                }
                if ("=".equals(operatorStr)) {
                    return EQUALS;
                }
                if ("!=".equals(operatorStr)) {
                    return NOT_EQUALS;
                }
                if ("^=".equals(operatorStr)) {
                    return STARTS_WITH;
                }
                if ("$=".equals(operatorStr)) {
                    return ENDS_WITH;
                }
                return null;
            }

            static String[] extractOperator(String specification) {
                int equalsPos = specification.indexOf(61);
                if (equalsPos == -1) {
                    return new String[]{specification.trim(), null, null};
                }
                char cprev = specification.charAt(equalsPos - 1);
                switch (cprev) {
                    case '!': {
                        return new String[]{specification.substring(0, equalsPos - 1).trim(), "!=", specification.substring(equalsPos + 1).trim()};
                    }
                    case '^': {
                        return new String[]{specification.substring(0, equalsPos - 1).trim(), "^=", specification.substring(equalsPos + 1).trim()};
                    }
                    case '$': {
                        return new String[]{specification.substring(0, equalsPos - 1).trim(), "$=", specification.substring(equalsPos + 1).trim()};
                    }
                }
                return new String[]{specification.substring(0, equalsPos).trim(), "=", specification.substring(equalsPos + 1).trim()};
            }
        }
    }
}

