/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.request;

import org.tiogasolutions.couchace.core.api.http.CouchHttpQuery;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.query.CouchPageQuery;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.request.GetAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.GetDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.GetDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.GetEntityRequest;
import org.tiogasolutions.couchace.core.internal.RequestExecutor;

public class GetRequestFactory {
    private final RequestExecutor requestExecutor;

    public GetRequestFactory(RequestExecutor requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    public GetDatabaseRequest database() {
        return new GetDatabaseRequest(this.requestExecutor, null);
    }

    public GetDatabaseRequest database(String path) {
        return new GetDatabaseRequest(this.requestExecutor, path);
    }

    public GetDatabaseRequest database(String path, CouchHttpQuery httpQuery) {
        return new GetDatabaseRequest(this.requestExecutor, path, httpQuery);
    }

    public GetDatabaseRequest database(String path, CouchMediaType contentType) {
        return new GetDatabaseRequest(this.requestExecutor, path, null, contentType);
    }

    public GetDatabaseRequest database(String path, CouchHttpQuery httpQuery, CouchMediaType contentType) {
        return new GetDatabaseRequest(this.requestExecutor, path, httpQuery, contentType);
    }

    public GetDocumentRequest document(String documentId) {
        return new GetDocumentRequest(this.requestExecutor, documentId, null);
    }

    public GetDocumentRequest document(String documentId, String revision) {
        return new GetDocumentRequest(this.requestExecutor, documentId, revision);
    }

    public GetDocumentRequest document(CouchViewQuery viewQuery) {
        return new GetDocumentRequest(this.requestExecutor, viewQuery);
    }

    public GetDocumentRequest document(CouchPageQuery pageQuery) {
        return new GetDocumentRequest(this.requestExecutor, pageQuery);
    }

    public GetAttachmentRequest attachment(String documentId, String attachmentName) {
        return new GetAttachmentRequest(this.requestExecutor, documentId, null, attachmentName);
    }

    public GetAttachmentRequest attachment(String documentId, String documentRevision, String attachmentName) {
        return new GetAttachmentRequest(this.requestExecutor, documentId, documentRevision, attachmentName);
    }

    public <T> GetEntityRequest<T> entity(Class<T> entityClass, String documentId) {
        return new GetEntityRequest<T>(this.requestExecutor, entityClass, documentId, null);
    }

    public <T> GetEntityRequest<T> entity(Class<T> entityClass, String documentId, String revision) {
        return new GetEntityRequest<T>(this.requestExecutor, entityClass, documentId, revision);
    }

    public <T> GetEntityRequest<T> entity(Class<T> entityClass, CouchViewQuery viewQuery) {
        return new GetEntityRequest<T>(this.requestExecutor, entityClass, viewQuery);
    }

    public <T> GetEntityRequest<T> entity(Class<T> entityClass, CouchPageQuery pageQuery) {
        return new GetEntityRequest<T>(this.requestExecutor, entityClass, pageQuery);
    }
}

