/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import ch.qos.logback.classic.Level;
import java.nio.file.Path;
import javax.ws.rs.core.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.app.common.AppPathResolver;
import org.tiogasolutions.app.common.LogUtils;
import org.tiogasolutions.lib.spring.jersey.JerseySpringBridge;
import org.tiogasolutions.notify.engine.web.NotifyApplication;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.LoggerFacade;

public class NotifyServer {
    private static final Logger log = LoggerFactory.getLogger(NotifyServer.class);
    public static final String DEFAULT_SPRING_FILE = "/org/tiogasolutions/notify/server/grizzly/spring-config.xml";

    public static void main(String ... args) throws Exception {
        LogUtils.initLogback((Level)Level.WARN);
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger(NotifyServer.class)).setLevel(Level.INFO);
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger(GrizzlyServer.class)).setLevel(Level.INFO);
        AppPathResolver resolver = new AppPathResolver(arg_0 -> ((Logger)LoggerFactory.getLogger(AppPathResolver.class)).info(arg_0), "notify.");
        Path runtimeDir = resolver.resolveRuntimePath();
        Path configDir = resolver.resolveConfigDir(runtimeDir);
        Path logbackFile = LogUtils.initLogback((Path)configDir, (String)"notify.log.config", (String)"logback.xml");
        String springConfigPath = resolver.resolveSpringPath(configDir, "classpath:/org/tiogasolutions/notify/server/grizzly/spring-config.xml");
        String activeProfiles = resolver.resolveSpringProfiles();
        log.info("Starting Notify Server:\n  *  Runtime Dir:  {}\n  *  Config Dir:   {}\n  *  Logback File: {}\n  *  Spring Path:  {}", new Object[]{runtimeDir, configDir, logbackFile, springConfigPath});
        NotifyApplication notifyApp = new NotifyApplication(activeProfiles, springConfigPath);
        GrizzlyServerConfig serverConfig = (GrizzlyServerConfig)notifyApp.getBeanFactory().getBean(GrizzlyServerConfig.class);
        LoggerFacade loggerFacade = new LoggerFacade(){

            public void info(String message) {
                LoggerFactory.getLogger(GrizzlyServer.class).info(message);
            }

            public void warn(String message) {
                LoggerFactory.getLogger(GrizzlyServer.class).warn(message);
            }

            public void error(String message, Throwable e) {
                LoggerFactory.getLogger(GrizzlyServer.class).error(message, e);
            }
        };
        GrizzlyServer grizzlyServer = new GrizzlyServer((Application)notifyApp, serverConfig, loggerFacade);
        JerseySpringBridge jerseySpringBridge = new JerseySpringBridge(notifyApp.getBeanFactory(), new Object[0]);
        grizzlyServer.getResourceConfig().register((Object)jerseySpringBridge);
        grizzlyServer.start();
    }
}

