/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.core.v1;

import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.notify.kernel.EventBus;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.request.LqRequestEntity;
import org.tiogasolutions.notify.kernel.request.LqRequestEntityStatus;
import org.tiogasolutions.notify.kernel.request.LqRequestStore;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.pub.DomainProfile;

public class SimpleRequestEntryResourceV1 {
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final EventBus eventBus;

    public SimpleRequestEntryResourceV1(ExecutionManager executionManager, DomainKernel domainKernel, EventBus eventBus) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
    }

    private DomainProfile getDomainProfile() {
        ExecutionContext ec = this.executionManager.context();
        return this.domainKernel.findByApiKey(ec.getApiKey());
    }

    @POST
    @Produces(value={"application/json"})
    public Response postRequest(@Context UriInfo uriInfo, LqRequest request) {
        CouchDatabase requestDb = this.domainKernel.requestDb(this.getDomainProfile());
        LqRequestStore store = new LqRequestStore(requestDb);
        LqRequestEntity requestEntity = LqRequestEntity.newEntity((LqRequest)request);
        if ((requestEntity = store.saveAndReload(requestEntity)).getRequestStatus() != LqRequestEntityStatus.READY) {
            requestEntity.ready();
            requestEntity = store.saveAndReload(requestEntity);
        }
        String domainName = this.executionManager.context().getDomainName();
        this.eventBus.requestCreated(domainName, requestEntity);
        URI uri = uriInfo.getRequestUriBuilder().path(requestEntity.getRequestId()).build(new Object[0]);
        return Response.created((URI)uri).build();
    }
}

