/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Map;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.pub.route.ArgValueMap;
import org.tiogasolutions.notify.pub.route.DestinationStatus;

public class Destination {
    private final String name;
    private final String provider;
    private final DestinationStatus destinationStatus;
    private ArgValueMap argMap;

    public Destination(String name, String provider, Map<String, ?> argMap) {
        this(name, provider, DestinationStatus.ENABLED, argMap);
    }

    @JsonCreator
    public Destination(@JsonProperty(value="name") String name, @JsonProperty(value="provider") String provider, @JsonProperty(value="destinationStatus") DestinationStatus destinationStatus, @JsonProperty(value="argMap") Map<String, ?> givenArgMap) {
        this.name = ExceptionUtils.assertNotZeroLength((String)name, (String)"name");
        this.provider = ExceptionUtils.assertNotZeroLength((String)provider, (String)"provider");
        this.destinationStatus = (DestinationStatus)((Object)ExceptionUtils.assertNotNull((Object)((Object)destinationStatus), (String)"provider"));
        this.argMap = new ArgValueMap(givenArgMap);
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    public DestinationStatus getDestinationStatus() {
        return this.destinationStatus;
    }

    @JsonUnwrapped
    public ArgValueMap getArgValueMap() {
        return this.argMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination that = (Destination)o;
        if (this.argMap != null ? !this.argMap.equals(that.argMap) : that.argMap != null) {
            return false;
        }
        if (this.destinationStatus != that.destinationStatus) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.provider != null ? !this.provider.equals(that.provider) : that.provider != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        result = 31 * result + (this.destinationStatus != null ? this.destinationStatus.hashCode() : 0);
        result = 31 * result + (this.argMap != null ? this.argMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Destination{name='" + this.name + '\'' + ", provider='" + this.provider + '\'' + ", destinationStatus=" + (Object)((Object)this.destinationStatus) + ", argMap=" + this.argMap + '}';
    }
}

