/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractIterationAttrProcessor;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.EachUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.util.StringUtils;

public abstract class AbstractStandardIterationAttrProcessor
extends AbstractIterationAttrProcessor {
    protected AbstractStandardIterationAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardIterationAttrProcessor(String attributeName) {
        super(attributeName);
    }

    protected void processClonedHostIterationElement(Arguments arguments, Element iteratedChild, String attributeName) {
    }

    protected final AbstractIterationAttrProcessor.IterationSpec getIterationSpec(Arguments arguments, Element element, String attributeName) {
        String statusVarName;
        String iterVarName;
        String attributeValue = element.getAttributeValue(attributeName);
        Configuration configuration = arguments.getConfiguration();
        Each each = EachUtils.parseEach(configuration, arguments, attributeValue);
        IStandardExpression iterVarExpr = each.getIterVar();
        Object iterVarValue = iterVarExpr.execute(configuration, arguments);
        IStandardExpression statusVarExpr = each.getStatusVar();
        Object statusVarValue = statusVarExpr != null ? statusVarExpr.execute(configuration, arguments) : null;
        IStandardExpression iterableExpr = each.getIterable();
        Object iteratedValue = iterableExpr.execute(configuration, arguments);
        String string = iterVarName = iterVarValue == null ? null : iterVarValue.toString();
        if (StringUtils.isEmptyOrWhitespace(iterVarName)) {
            throw new TemplateProcessingException("Iteration variable name expression evaluated as null: \"" + iterVarExpr + "\"");
        }
        String string2 = statusVarName = statusVarValue == null ? null : statusVarValue.toString();
        if (statusVarExpr != null && StringUtils.isEmptyOrWhitespace(statusVarName)) {
            throw new TemplateProcessingException("Status variable name expression evaluated as null or empty: \"" + statusVarExpr + "\"");
        }
        return new AbstractIterationAttrProcessor.IterationSpec(iterVarName, statusVarName, iteratedValue);
    }
}

