/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonInjectable;
import org.tiogasolutions.dev.jackson.TiogaJacksonObjectMapper;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslatorException;

public class TiogaJacksonTranslator
implements JsonTranslator {
    private final ObjectMapper jacksonMapper;

    public TiogaJacksonTranslator() {
        this.jacksonMapper = this.createObjectMapper(TiogaJacksonObjectMapper.defaultModules(), Collections.emptyList());
    }

    public TiogaJacksonTranslator(Collection<? extends TiogaJacksonInjectable> injectables) {
        this.jacksonMapper = this.createObjectMapper(TiogaJacksonObjectMapper.defaultModules(), injectables);
    }

    public TiogaJacksonTranslator(Collection<? extends Module> modules, Collection<? extends TiogaJacksonInjectable> injectables) {
        this.jacksonMapper = this.createObjectMapper(modules, injectables);
    }

    public TiogaJacksonTranslator(ObjectMapper jacksonMapper) {
        this.jacksonMapper = jacksonMapper;
    }

    protected ObjectMapper createObjectMapper(Collection<? extends Module> modules, Collection<? extends TiogaJacksonInjectable> injectables) {
        return new TiogaJacksonObjectMapper(modules, injectables);
    }

    public String toJson(Object domain) {
        try {
            return this.jacksonMapper.writeValueAsString(domain).replaceAll("\r", "");
        }
        catch (JsonProcessingException e) {
            throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
        }
    }

    public <T> T fromJson(Class<T> type, String json, Class<?> ... parameterTypes) {
        if (parameterTypes != null && parameterTypes.length > 0) {
            try {
                JavaType javaType = this.jacksonMapper.getTypeFactory().constructParametricType(type, (Class[])parameterTypes);
                return (T)this.jacksonMapper.readValue(json, javaType);
            }
            catch (IOException e) {
                String msg = String.format("Exception translating %s from json.", type.getName());
                throw new TiogaJacksonTranslatorException(msg, e);
            }
        }
        try {
            return (T)this.jacksonMapper.readValue(json, type);
        }
        catch (IOException e) {
            String msg = String.format("Exception translating %s from json.", type.getName());
            throw new TiogaJacksonTranslatorException(msg, e);
        }
    }
}

