/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Conversions {
    private final Configuration configuration;
    private final IProcessingContext processingContext;

    public Conversions(Configuration configuration, IProcessingContext processingContext) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Processing context cannot be null");
        this.configuration = configuration;
        this.processingContext = processingContext;
    }

    public Object convert(Object target, String className) {
        ClassLoader cl = ClassLoaderUtils.getClassLoader(Conversions.class);
        try {
            Class<?> clazz = cl.loadClass(className);
            return this.convert(target, clazz);
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> clazz = cl.loadClass("java.lang." + className);
                return this.convert(target, clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Cannot convert to class '" + className + "'", e);
            }
        }
    }

    public Object convert(Object target, Class<?> clazz) {
        IStandardConversionService conversionService = StandardExpressions.getConversionService(this.configuration);
        return conversionService.convert(this.configuration, this.processingContext, target, clazz);
    }
}

