/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.fine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.dev.common.EqualsUtils;

public class TraitMap
implements Serializable {
    private static final TraitMap empty = new TraitMap(new String[0]);
    private final Map<String, String> m;

    public static TraitMap empty() {
        return empty;
    }

    public TraitMap(TraitMap givenMap) {
        this(givenMap == null ? null : givenMap.getMap());
    }

    public TraitMap(Map<?, ?> givenMap) {
        if (givenMap == null) {
            this.m = Collections.emptyMap();
            return;
        }
        TreeMap<String, String> localMap = new TreeMap<String, String>();
        for (Map.Entry<?, ?> entry : givenMap.entrySet()) {
            if (entry.getKey() == null) continue;
            String key = this.fixCase(entry.getKey().toString());
            Object value = entry.getValue();
            if (value == null) {
                localMap.put(key, null);
                continue;
            }
            localMap.put(key, value.toString());
        }
        this.m = Collections.unmodifiableSortedMap(localMap);
    }

    public TraitMap(String ... traitStrings) {
        this(BeanUtils.toMap(traitStrings));
    }

    public TraitMap(Collection<String> traitStrings) {
        this(BeanUtils.toMap(traitStrings));
    }

    public TraitMap add(String ... traits) {
        return this.add(traits == null ? Collections.emptyMap() : BeanUtils.toMap(traits));
    }

    public TraitMap add(Collection<String> traits) {
        return this.add(traits == null ? Collections.emptyMap() : BeanUtils.toMap(traits));
    }

    public TraitMap add(TraitMap map) {
        return this.add(map == null ? Collections.emptyMap() : map.getMap());
    }

    public TraitMap add(Map<?, ?> traitMapArg) {
        if (traitMapArg == null) {
            return this;
        }
        HashMap<String, String> localMap = new HashMap<String, String>(this.m);
        for (Map.Entry<?, ?> entry : traitMapArg.entrySet()) {
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) {
                localMap.put(entry.getKey().toString(), null);
                continue;
            }
            localMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return new TraitMap(localMap);
    }

    public TraitMap remove(String ... traits) {
        return this.remove(traits == null ? Collections.emptyList() : Arrays.asList(traits));
    }

    public TraitMap remove(Collection<String> traits) {
        if (traits == null) {
            return this;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.m.entrySet()) {
            if (this.containsKey(traits, entry.getKey())) continue;
            newMap.put(entry.getKey(), entry.getValue());
        }
        return new TraitMap(newMap);
    }

    protected boolean containsKey(Map<String, String> map, String key) {
        return this.containsKey(map.keySet(), key);
    }

    protected boolean containsKey(Collection<String> collection, String key) {
        for (String entry : collection) {
            if (!this.keysEqual(entry, key)) continue;
            return true;
        }
        return false;
    }

    protected boolean keysEqual(String keyA, String keyB) {
        if (keyA == null && keyB == null) {
            return true;
        }
        if (keyA == null || keyB == null) {
            return false;
        }
        return keyA.equalsIgnoreCase(keyB);
    }

    public Map<String, String> getMap() {
        return this.m;
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.m.isEmpty();
    }

    public int getSize() {
        return this.m.size();
    }

    public boolean hasTrait(String key) {
        if (key == null) {
            return false;
        }
        return this.containsKey(this.m.keySet(), key);
    }

    public boolean hasValue(String key, String checkValue) {
        if (key == null) {
            return false;
        }
        String value = this.getValue(key);
        return EqualsUtils.objectsEqual(checkValue, value);
    }

    public String getValue(String key) {
        for (Map.Entry<String, String> entry : this.m.entrySet()) {
            if (!this.keysEqual(entry.getKey(), key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.m.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            if (entry.getValue() == null) {
                sb.append("null");
            } else {
                sb.append("\"");
                sb.append(entry.getValue());
                sb.append("\"");
            }
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        int thatCount;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraitMap that = (TraitMap)o;
        int thisCount = this.getSize();
        if (thisCount != (thatCount = that.getSize())) {
            return false;
        }
        ArrayList<String> thisKeys = new ArrayList<String>(this.getMap().keySet());
        ArrayList<String> thatKeys = new ArrayList<String>(that.getMap().keySet());
        for (int i = 0; i < thisKeys.size(); ++i) {
            String thatValue;
            String thatKey;
            String thisKey = (String)thisKeys.get(i);
            if (!thisKey.equalsIgnoreCase(thatKey = (String)thatKeys.get(i))) {
                return false;
            }
            String thisValue = this.getValue(thisKey);
            if (!EqualsUtils.objectsNotEqual(thisValue, thatValue = that.getValue(thatKey))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.getClass().getName().hashCode();
        result = 31 * result + this.m.hashCode();
        return result;
    }

    public String toString() {
        return this.getText();
    }

    protected String fixCase(String value) {
        return value;
    }
}

