/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.lib.jaxrs.jackson.SimpleRestClient;
import org.tiogasolutions.push.client.PushServerClient;
import org.tiogasolutions.push.jackson.CpObjectMapper;
import org.tiogasolutions.push.pub.common.PingPush;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.PushResponse;
import org.tiogasolutions.push.pub.internal.RequestErrors;

public class LivePushServerClient
implements PushServerClient {
    private final SimpleRestClient client;

    public LivePushServerClient(String userName, String password) {
        CpObjectMapper objectMapper = new CpObjectMapper();
        TiogaJacksonTranslator translator = new TiogaJacksonTranslator((ObjectMapper)objectMapper);
        this.client = new SimpleRestClient((JsonTranslator)translator, "http://www.cosmicpush.com/api/v2", userName, password);
    }

    public LivePushServerClient(String url, String userName, String password) {
        CpObjectMapper objectMapper = new CpObjectMapper();
        TiogaJacksonTranslator translator = new TiogaJacksonTranslator((ObjectMapper)objectMapper);
        this.client = new SimpleRestClient((JsonTranslator)translator, url, userName, password);
    }

    public LivePushServerClient(SimpleRestClient client) {
        this.client = client;
    }

    public SimpleRestClient getClient() {
        return this.client;
    }

    @Override
    public long ping() {
        long start = System.currentTimeMillis();
        this.send((Push)PingPush.newPush());
        return System.currentTimeMillis() - start;
    }

    @Override
    public PushResponse send(Push push) {
        push.validate(new RequestErrors()).assertNoErrors();
        return (PushResponse)this.getClient().post(PushResponse.class, "/pushes", (Object)push);
    }

    @Override
    public PushResponse push(Push push) {
        return this.send(push);
    }
}

