/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.receiver;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.notify.kernel.LqPubUtils;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.CreateAttachment;
import org.tiogasolutions.notify.kernel.notification.CreateNotification;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.receiver.RequestReceiver;
import org.tiogasolutions.notify.kernel.request.LqAttachmentHolder;
import org.tiogasolutions.notify.kernel.request.LqAttachmentInfo;
import org.tiogasolutions.notify.kernel.request.LqRequestEntity;
import org.tiogasolutions.notify.kernel.request.LqRequestEntityStatus;
import org.tiogasolutions.notify.kernel.request.LqRequestStore;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.ExceptionInfo;
import org.tiogasolutions.notify.pub.NotificationRef;

public class CouchRequestReceiver
implements RequestReceiver {
    private static final Logger log = LoggerFactory.getLogger(CouchRequestReceiver.class);
    private final DomainKernel domainKernel;
    private final NotificationKernel notificationKernel;
    private final ExecutionManager executionManager;

    public CouchRequestReceiver(DomainKernel domainKernel, NotificationKernel notificationKernel, ExecutionManager executionManager) {
        this.domainKernel = domainKernel;
        this.notificationKernel = notificationKernel;
        this.executionManager = executionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveRequests(DomainProfile domainProfile) {
        try {
            this.executionManager.newApiContext(domainProfile);
            CouchDatabase requestDb = this.domainKernel.requestDb(domainProfile);
            LqRequestStore requestStore = new LqRequestStore(requestDb);
            List<LqRequestEntity> readyRequests = requestStore.findByStatus(LqRequestEntityStatus.READY);
            for (LqRequestEntity request : readyRequests) {
                NotificationRef notificationRef = null;
                try {
                    request.processing();
                    request = requestStore.saveAndReload(request);
                    ExceptionInfo exceptionInfo = LqPubUtils.toExceptionInfo(request.getExceptionInfo());
                    CreateNotification createNotification = new CreateNotification(request.getTopic(), request.getSummary(), request.getTrackingId(), request.getCreatedAt(), exceptionInfo, request.getTraitMap());
                    notificationRef = this.notificationKernel.createNotification(createNotification);
                    for (LqAttachmentInfo attachmentInfo : request.listAttachmentInfo()) {
                        LqAttachmentHolder holder = requestStore.findAttachment(request.getRequestId(), attachmentInfo.getName());
                        CreateAttachment createAttachment = new CreateAttachment(notificationRef, holder.getName(), holder.getContentType(), holder.getContent());
                        notificationRef = this.notificationKernel.createAttachment(createAttachment);
                    }
                    request.completed();
                    requestStore.save(request);
                }
                catch (Throwable t) {
                    log.error("Exception generating notification for request.", t);
                    this.handleFailure(requestStore, request, notificationRef);
                }
            }
            if (!readyRequests.isEmpty()) {
                log.info("Imported {} notifications for the domain {}.", (Object)readyRequests.size(), (Object)domainProfile.getDomainName());
            }
        }
        finally {
            this.executionManager.clearContext();
        }
    }

    protected void handleFailure(LqRequestStore requestStore, LqRequestEntity request, NotificationRef notificationRef) {
        try {
            request.failed();
            requestStore.save(request);
        }
        catch (Throwable t) {
            log.error("Error in couch receiver handling failure.", t);
        }
    }
}

