/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.net.URI;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.GetResponse;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;

public class GetAttachmentResponse
extends GetResponse {
    private final String documentId;
    private final String etag;
    private final Object content;

    public GetAttachmentResponse(URI uri, CouchHttpStatus statusCode, String documentId, String etag, CouchMediaType contentType, Object content, CouchErrorContent errorContent) {
        super(uri, statusCode, contentType, errorContent);
        ArgUtil.assertNotNull(uri, "URI");
        this.documentId = documentId;
        this.etag = etag;
        this.content = content;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getEtag() {
        return this.etag;
    }

    public boolean hasEtag() {
        return this.etag != null;
    }

    public Object getContent() {
        return this.content;
    }

    public String getStringContent() {
        return this.content != null ? this.content.toString() : null;
    }

    @Override
    public CouchErrorContent getErrorContent() {
        return CouchErrorContent.parseJson(this.getStringContent());
    }

    @Override
    public String getErrorReason() {
        return this.getErrorContent().getReason();
    }

    public boolean isEmpty() {
        if (this.content == null) {
            return true;
        }
        if (this.content instanceof String) {
            return ((String)this.content).isEmpty();
        }
        return false;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

