/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.pub.attachment.AttachmentInfo;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.notification.NotificationRef;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Notification
implements Comparable<Notification> {
    private final URI self;
    private final String domainName;
    private final String notificationId;
    private final String revision;
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final ExceptionInfo exceptionInfo;
    private final List<AttachmentInfo> attachmentInfoList;

    @JsonCreator
    public Notification(@JsonProperty(value="self") URI self, @JsonProperty(value="domainName") String domainName, @JsonProperty(value="notificationId") String notificationId, @JsonProperty(value="revision") String revision, @JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="traitMap") Map<String, String> traitMap, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo, @JsonProperty(value="attachmentInfoList") List<AttachmentInfo> attachmentInfoList) {
        this.self = self;
        this.domainName = domainName;
        this.notificationId = notificationId;
        this.revision = revision;
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt;
        this.traitMap = traitMap;
        this.exceptionInfo = exceptionInfo;
        this.attachmentInfoList = attachmentInfoList;
    }

    public NotificationRef toNotificationRef() {
        return new NotificationRef(this.domainName, this.notificationId, this.revision);
    }

    public URI getSelf() {
        return this.self;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getCreatedAtLocal() {
        return this.createdAt.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<AttachmentInfo> getAttachmentInfoList() {
        return this.attachmentInfoList;
    }

    @Override
    public int compareTo(Notification that) {
        int diff = this.createdAt.compareTo(that.createdAt);
        if (diff != 0) {
            return diff;
        }
        return this.notificationId.compareTo(that.notificationId);
    }

    public String toString() {
        return "Notification{self=" + this.self + ", domainName='" + this.domainName + '\'' + ", notificationId='" + this.notificationId + '\'' + ", revision='" + this.revision + '\'' + ", topic='" + this.topic + '\'' + ", summary='" + this.summary + '\'' + ", trackingId='" + this.trackingId + '\'' + ", createdAt=" + this.createdAt + ", traitMap=" + this.traitMap + ", exceptionInfo=" + this.exceptionInfo + ", attachmentInfoList=" + this.attachmentInfoList + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        if (!this.domainName.equals(that.domainName)) {
            return false;
        }
        if (!this.notificationId.equals(that.notificationId)) {
            return false;
        }
        return this.revision.equals(that.revision);
    }

    public int hashCode() {
        int result = this.domainName.hashCode();
        result = 31 * result + this.notificationId.hashCode();
        result = 31 * result + this.revision.hashCode();
        return result;
    }
}

