/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

public abstract class AbstractMarkupRemovalAttrProcessor
extends AbstractAttrProcessor {
    protected AbstractMarkupRemovalAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractMarkupRemovalAttrProcessor(String attributeName) {
        super(attributeName);
    }

    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        RemovalType removalType = this.getRemovalType(arguments, element, attributeName);
        if (removalType == null) {
            return ProcessorResult.OK;
        }
        switch (removalType) {
            case NONE: {
                element.removeAttribute(attributeName);
                return ProcessorResult.OK;
            }
            case ALL: {
                element.getParent().removeChild(element);
                return ProcessorResult.OK;
            }
            case ALLBUTFIRST: {
                List<Node> children = element.getChildren();
                ArrayList<Node> newChildren = new ArrayList<Node>(children.size());
                boolean childElementFound = false;
                for (Node child : children) {
                    if (child instanceof Element) {
                        if (childElementFound) continue;
                        newChildren.add(child);
                        childElementFound = true;
                        continue;
                    }
                    newChildren.add(child);
                }
                element.setChildren(newChildren);
                element.removeAttribute(attributeName);
                return ProcessorResult.OK;
            }
            case ELEMENT: {
                element.getParent().extractChild(element);
                return ProcessorResult.OK;
            }
            case BODY: {
                element.clearChildren();
                element.removeAttribute(attributeName);
                return ProcessorResult.OK;
            }
        }
        return ProcessorResult.OK;
    }

    protected abstract RemovalType getRemovalType(Arguments var1, Element var2, String var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RemovalType {
        ALL,
        ALLBUTFIRST,
        ELEMENT,
        BODY,
        NONE;

    }
}

