/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.request;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.notifier.request.NotificationAttachment;
import org.tiogasolutions.notify.notifier.request.NotificationExceptionInfo;

public final class NotificationRequest {
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final NotificationExceptionInfo exceptionInfo;
    private final Map<String, String> traitMap;
    private final List<NotificationAttachment> attachments;

    public NotificationRequest(String topic, String summary, String trackingId, ZonedDateTime createdAt, Map<String, String> traitsArg, NotificationExceptionInfo exceptionInfo, Collection<NotificationAttachment> attachmentsArg) {
        this.topic = topic != null ? topic : "none";
        this.summary = summary != null ? summary : "none";
        this.trackingId = trackingId;
        this.exceptionInfo = exceptionInfo;
        this.createdAt = createdAt != null ? createdAt : ZonedDateTime.now();
        LinkedHashMap<String, String> traitMap = new LinkedHashMap<String, String>();
        if (traitsArg != null) {
            traitMap.putAll(traitsArg);
        }
        this.traitMap = Collections.unmodifiableMap(traitMap);
        ArrayList<NotificationAttachment> attachmentsList = new ArrayList<NotificationAttachment>();
        if (attachmentsArg != null) {
            attachmentsList.addAll(attachmentsArg);
        }
        this.attachments = Collections.unmodifiableList(attachmentsList);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getSummary() {
        return this.summary;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public NotificationExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<NotificationAttachment> getAttachments() {
        return this.attachments;
    }

    public static enum Status {
        SENDING,
        READY,
        PROCESSING,
        FAILED,
        COMPLETED;

    }
}

