/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.sender;

import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.notify.notifier.request.NotificationAttachment;
import org.tiogasolutions.notify.notifier.request.NotificationAttachmentFailureCallback;
import org.tiogasolutions.notify.notifier.request.NotificationRequest;
import org.tiogasolutions.notify.notifier.request.NotificationResponse;
import org.tiogasolutions.notify.notifier.request.NotificationResponseCallback;

public class NotificationSenderCallbacks {
    private final List<NotificationResponseCallback> responseCallbacks = new ArrayList<NotificationResponseCallback>();
    private final List<NotificationResponseCallback> successCallbacks = new ArrayList<NotificationResponseCallback>();
    private final List<NotificationResponseCallback> failureCallbacks = new ArrayList<NotificationResponseCallback>();
    private final List<NotificationAttachmentFailureCallback> attachmentFailureCallbacks = new ArrayList<NotificationAttachmentFailureCallback>();

    public void onResponse(NotificationResponseCallback callback) {
        this.responseCallbacks.add(callback);
    }

    public void onSuccess(NotificationResponseCallback callback) {
        this.successCallbacks.add(callback);
    }

    public void onFailure(NotificationResponseCallback callback) {
        this.failureCallbacks.add(callback);
    }

    public void onFailure(NotificationAttachmentFailureCallback callback) {
        this.attachmentFailureCallbacks.add(callback);
    }

    public void callResponse(NotificationResponse response) {
        this.responseCallbacks.stream().forEachOrdered(c -> c.call(response));
    }

    public void callSuccess(NotificationResponse response) {
        this.successCallbacks.stream().forEachOrdered(c -> c.call(response));
        this.callResponse(response);
    }

    public void callFailure(NotificationResponse response) {
        this.failureCallbacks.stream().forEachOrdered(c -> c.call(response));
    }

    public void callFailure(NotificationRequest request, NotificationAttachment attachment, Throwable t) {
        this.attachmentFailureCallbacks.stream().forEachOrdered(c -> c.call(request, attachment, t));
    }
}

