/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.spring.jaxrs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class TiogaSpringApplication
extends Application {
    protected final Set<Class<?>> classes = new HashSet();
    protected final Set<Object> singletons = new HashSet<Object>();
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected final ListableBeanFactory beanFactory;

    public TiogaSpringApplication(String profile, String springFile, Map<String, Object> properties, Set<Class<?>> classes, Set<Object> singletons) {
        Object springContext = springFile.startsWith("classpath:") ? new ClassPathXmlApplicationContext() : new FileSystemXmlApplicationContext();
        springContext.setConfigLocation(springFile);
        springContext.getEnvironment().setActiveProfiles(new String[]{profile});
        springContext.refresh();
        this.beanFactory = springContext;
        this.classes.addAll(classes);
        this.singletons.addAll(singletons);
        this.properties.putAll(properties);
        this.checkForDuplicates();
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    protected void checkForDuplicates() {
        HashSet existing = new HashSet();
        for (Class<?> type : this.classes) {
            if (type == null || !existing.contains(type)) continue;
            String msg = String.format("The class %s has already been registered.", type.getName());
            throw new IllegalArgumentException(msg);
        }
        existing.clear();
    }
}

