/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub.internal;

import java.util.Arrays;
import java.util.List;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.push.pub.internal.RequestErrors;

public class ValidationUtils {
    private static final List<String> invalidSecurityChr = Arrays.asList(" ", ",", "\t", "<", ">", "#", "|", "&", "~", "?", "(", ")", "{", "}");

    public static void requireValue(RequestErrors errors, Object value, String errorMessage) {
        if (value instanceof Integer) {
            if ((Integer)value == 0) {
                errors.add(errorMessage);
            }
        } else if (value instanceof Long) {
            if ((Long)value == 0L) {
                errors.add(errorMessage);
            }
        } else if (StringUtils.isBlank((Object)value)) {
            errors.add(errorMessage);
        }
    }

    public static void requireNull(RequestErrors errors, Object value, String errorMessage) {
        if (value instanceof Integer) {
            if ((Integer)value != 0) {
                errors.add(errorMessage);
            }
        } else if (value instanceof Long) {
            if ((Long)value != 0L) {
                errors.add(errorMessage);
            }
        } else if (StringUtils.isNotBlank((Object)value)) {
            errors.add(errorMessage);
        }
    }

    public static void validatePhoneNumber(String what, List<String> errors, String phoneNumber) {
        if (phoneNumber.length() != 10) {
            errors.add("The " + what + " number must be 10 digit long.");
        } else {
            try {
                Long.valueOf(phoneNumber);
            }
            catch (NumberFormatException e) {
                errors.add("The " + what + " number specified is not a valid 10 digit phone number.");
            }
        }
    }

    private ValidationUtils() {
    }

    public static void validateUserName(RequestErrors errors, String userName, String what) {
        ValidationUtils.validSecurityField(errors, userName, String.format("The %s must be specified.", what));
    }

    public static void validatePassword(RequestErrors errors, String password, String what) {
        ValidationUtils.validSecurityField(errors, password, String.format("The %s must be specified.", what));
    }

    private static void validSecurityField(RequestErrors errors, String value, String what) {
        ValidationUtils.requireValue(errors, value, String.format("The %s must be specified.", what));
        if (StringUtils.isBlank((Object)value)) {
            return;
        }
        for (String chr : invalidSecurityChr) {
            if (!value.contains(chr)) continue;
            String list = StringUtils.toDelineatedString((String)"  ", invalidSecurityChr);
            String msg = String.format("The %s cannot contain the following characters:  %s", what, list);
            errors.add(msg);
            break;
        }
    }

    public static void requireInteger(RequestErrors errors, String value, String message) {
        if (StringUtils.isNotBlank((Object)value)) {
            try {
                Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                errors.add(message);
            }
        }
    }
}

