/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.notification;

import java.util.List;
import java.util.stream.Collectors;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.response.GetAttachmentResponse;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.kernel.common.AbstractStore;
import org.tiogasolutions.notify.kernel.notification.CreateAttachment;
import org.tiogasolutions.notify.kernel.notification.NotificationCouchView;
import org.tiogasolutions.notify.kernel.notification.NotificationEntity;
import org.tiogasolutions.notify.kernel.request.RequestCouchView;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.attachment.AttachmentHolder;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationQuery;
import org.tiogasolutions.notify.pub.notification.NotificationRef;

public class NotificationStore
extends AbstractStore {
    public NotificationStore(CouchDatabase couchDatabase) {
        super(couchDatabase);
    }

    public NotificationEntity saveAndReload(NotificationEntity entity) {
        ExceptionUtils.assertNotNull((Object)entity, (String)"entity");
        this.couchDatabase.put().entity((Object)entity).onError(r -> this.throwError(r, String.format("Error saving %s with id %s", TaskEntity.class, entity.getNotificationId()))).execute();
        return this.findNotificationById(entity.getNotificationId());
    }

    public NotificationEntity findNotificationById(String notificationId) {
        GetEntityResponse getResponse = this.couchDatabase.get().entity(NotificationEntity.class, notificationId).onError(r -> this.throwError(r, "Error finding Notification by notification id " + notificationId)).onResponse(r -> this.throwIfNotFound((GetEntityResponse)r, "Notification not found by notification id " + notificationId)).execute();
        return (NotificationEntity)getResponse.getFirstEntity();
    }

    public QueryResult<Notification> query(NotificationQuery query) {
        String traitKey;
        CouchViewQuery viewQuery;
        String errorSuffix;
        int limit;
        int n = limit = query.getLimit() <= 500 ? query.getLimit() : 500;
        if (StringUtils.isNotBlank((Object)query.getNotificationId())) {
            NotificationEntity notificationEntity = this.findNotificationById(query.getNotificationId());
            return ListQueryResult.newSingle(Notification.class, (Object)notificationEntity.toNotification());
        }
        if (StringUtils.isNotBlank((Object)query.getTrackingId())) {
            errorSuffix = "by tracking id " + query.getTrackingId();
            String trackingId = query.getTrackingId();
            viewQuery = CouchViewQuery.builder((String)"Notification", (String)RequestCouchView.ByTrackingId.name()).key(new Object[]{trackingId}).limit(limit + 1).skip(query.getOffset()).build();
        } else if (StringUtils.isNotBlank((Object)query.getTopic())) {
            errorSuffix = "by topic" + query.getTopic();
            String topic = query.getTopic().toLowerCase();
            viewQuery = CouchViewQuery.builder((String)"Notification", (String)NotificationCouchView.ByTopicAndCreatedAt.name()).start(new Object[]{topic, "\\ufff0"}).end(new Object[]{topic, null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        } else if (StringUtils.isNotBlank((Object)query.getTraitKey()) && StringUtils.isNotBlank((Object)query.getTraitValue())) {
            errorSuffix = String.format("by trait key: %s value: %s", query.getTraitKey(), query.getTraitValue());
            traitKey = query.getTraitKey().toLowerCase();
            String traitValue = query.getTraitValue().toLowerCase();
            viewQuery = CouchViewQuery.builder((String)"Notification", (String)NotificationCouchView.ByTraitKeyValueAndCreatedAt.name()).start(new Object[]{traitKey, traitValue, "\\ufff0"}).end(new Object[]{traitKey, traitValue, null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        } else if (StringUtils.isNotBlank((Object)query.getTraitKey())) {
            errorSuffix = String.format("by trait key: %s", query.getTraitKey());
            traitKey = query.getTraitKey().toLowerCase();
            viewQuery = CouchViewQuery.builder((String)"Notification", (String)NotificationCouchView.ByTraitKeyAndCreatedAt.name()).start(new Object[]{traitKey, "\\ufff0"}).end(new Object[]{traitKey, null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        } else if (StringUtils.isNotBlank((Object)query.getSummary())) {
            errorSuffix = String.format("by summary: %s", query.getTraitKey());
            String summary = query.getSummary().toLowerCase();
            viewQuery = CouchViewQuery.builder((String)"Notification", (String)NotificationCouchView.BySummary.name()).start(new Object[]{summary}).end(new Object[]{"\\ufff0"}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        } else {
            errorSuffix = "by created at";
            viewQuery = CouchViewQuery.builder((String)"Notification", (String)NotificationCouchView.ByCreatedAt.name()).start(new Object[]{"\\ufff0"}).end(new Object[]{null}).limit(limit + 1).skip(query.getOffset()).descending(true).build();
        }
        GetEntityResponse getResponse = this.couchDatabase.get().entity(NotificationEntity.class, viewQuery).onError(r -> this.throwError(r, "Error finding Notification " + errorSuffix)).execute();
        List notifications = getResponse.getEntityList().stream().map(NotificationEntity::toNotification).limit(limit).collect(Collectors.toList());
        return ListQueryResult.newResult(Notification.class, (int)limit, (int)query.getOffset(), (int)getResponse.getSize(), (boolean)false, notifications);
    }

    public NotificationRef createAttachment(CreateAttachment create) {
        CouchMediaType mediaType = CouchMediaType.fromString((String)create.getContentType());
        NotificationRef notificationRef = create.getNotificationRef();
        WriteResponse response = this.couchDatabase.put().attachment(notificationRef.getNotificationId(), notificationRef.getRevision(), create.getAttachmentName(), mediaType, (Object)create.getInputStream()).onError(r -> this.throwError(r, String.format("Failure storing notification attachment in couch [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
        return new NotificationRef(notificationRef.getDomainName(), notificationRef.getNotificationId(), response.getDocumentRevision());
    }

    public AttachmentHolder findAttachment(String notificationId, String attachmentName) {
        GetAttachmentResponse attachmentResponse = this.couchDatabase.get().attachment(notificationId, attachmentName).onError(r -> this.throwError(r, "Error finding attachment " + attachmentName)).onResponse(r -> this.throwIfNotFound((GetAttachmentResponse)r, "Attachment not found " + attachmentName)).execute();
        byte[] content = attachmentResponse.getContent() instanceof byte[] ? (byte[])attachmentResponse.getContent() : attachmentResponse.getStringContent().getBytes();
        return new AttachmentHolder(attachmentName, attachmentResponse.getContentType().getMediaString(), content);
    }

    public void deleteNotification(String notificationId) {
        NotificationEntity notification;
        ExceptionUtils.assertNotNull((Object)notificationId, (String)"notificationId");
        try {
            notification = this.findNotificationById(notificationId);
        }
        catch (ApiNotFoundException e) {
            return;
        }
        this.couchDatabase.delete().document(notification.getNotificationId(), notification.getRevision()).onError(r -> this.throwError(r, String.format("Error deleting %s with id %s", TaskEntity.class, notification.getNotificationId()))).execute();
    }
}

