/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.PushType;
import org.tiogasolutions.push.pub.internal.PushUtils;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class TwilioSmsPush
implements Push,
Serializable {
    public static final PushType PUSH_TYPE = new PushType(TwilioSmsPush.class, "twilio", "Twilio");
    private final String from;
    private final String recipient;
    private final String message;
    private String remoteHost;
    private String remoteAddress;
    private Map<String, String> traits = new LinkedHashMap<String, String>();
    private final String callbackUrl;

    private TwilioSmsPush(@JsonProperty(value="from") String from, @JsonProperty(value="recipient") String recipient, @JsonProperty(value="message") String message, @JsonProperty(value="callbackUrl") String callbackUrl, @JsonProperty(value="remoteHost") String remoteHost, @JsonProperty(value="remoteAddress") String remoteAddress, @JsonProperty(value="traits") Map<String, String> traits) {
        this.from = from;
        this.recipient = recipient;
        this.message = message;
        this.callbackUrl = callbackUrl;
        this.remoteHost = remoteHost;
        this.remoteAddress = remoteAddress;
        if (traits != null) {
            this.traits.putAll(traits);
        }
    }

    @Override
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Override
    public PushType getPushType() {
        return PUSH_TYPE;
    }

    @Override
    public RequestErrors validate(RequestErrors errors) {
        ValidationUtils.requireValue(errors, this.recipient, "The from field must be specified.");
        ValidationUtils.requireValue(errors, this.recipient, "The recipient must be specified.");
        ValidationUtils.requireValue(errors, this.message, "The message must be specified.");
        return errors;
    }

    @Override
    public Map<String, String> getTraits() {
        return this.traits;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getFrom() {
        return this.from;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getMessage() {
        return this.message;
    }

    public static TwilioSmsPush newPush(String from, String recipient, String message, String callbackUrl, String ... traits) {
        InetAddress remoteAddress = PushUtils.getLocalHost();
        return new TwilioSmsPush(from, recipient, message, callbackUrl, remoteAddress.getCanonicalHostName(), remoteAddress.getHostAddress(), BeanUtils.toMap((String[])traits));
    }

    public static TwilioSmsPush newPush(String from, String recipient, String message, String callbackUrl, Map<String, String> traits) {
        InetAddress remoteAddress = PushUtils.getLocalHost();
        return new TwilioSmsPush(from, recipient, message, callbackUrl, remoteAddress.getCanonicalHostName(), remoteAddress.getHostAddress(), traits);
    }
}

