/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.config;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.Validation;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.tiogasolutions.dev.common.id.IdGenerator;
import org.tiogasolutions.dev.common.id.TwoPartIdGenerator;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.domain.validation.BeanValidator;
import org.tiogasolutions.dev.domain.validation.Jsr349BeanValidator;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;

@Configuration
@EnableAspectJAutoProxy
public class SpringConfig {
    @Bean
    public JsonTranslator jsonTranslator() {
        return new TiogaJacksonTranslator();
    }

    @Bean
    public IdGenerator idGenerator() {
        return new TwoPartIdGenerator();
    }

    @Bean
    public BeanValidator validator() {
        return new Jsr349BeanValidator(Validation.buildDefaultValidatorFactory());
    }

    @Bean(name={"DomainKeyGenerator"})
    public IdGenerator domainKeyGenerator() {
        return new TwoPartIdGenerator("%s-%s", ZonedDateTime.of(2014, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC")), "ABCDFGHJKLMNPQRSTVWXYZ", 20, 5, 7);
    }
}

