/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api;

import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchSetup;
import org.tiogasolutions.couchace.core.api.http.CouchHttpException;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaRepository;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.couchace.core.internal.CouchDatabaseImpl;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpClient;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;
import org.tiogasolutions.couchace.core.spi.http.HttpGetRequest;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;

public class CouchServer {
    private final CouchHttpClient httpClient;
    private final CouchJsonStrategy jsonStrategy;
    private final CouchMetaRepository metaRepository;

    public CouchServer(CouchSetup couchSetup) {
        this.httpClient = couchSetup.getHttpClient();
        this.jsonStrategy = couchSetup.getJsonStrategy();
        this.metaRepository = couchSetup.getMetaRepository();
    }

    public void assertConnection() throws CouchHttpException {
        CouchHttpResponse response;
        try {
            response = this.httpClient.get(new HttpGetRequest());
        }
        catch (Throwable e) {
            throw CouchHttpException.internalServerError(e);
        }
        if (response.isOk()) {
            String content = response.getStringContent();
            if (!content.contains("couchdb")) {
                String msg = String.format("The server at " + this.httpClient.getBaseUrl() + " is not a couch database.", new Object[0]);
                throw new CouchHttpException(CouchHttpStatus.CONFLICT, msg);
            }
        } else {
            throw new CouchHttpException(response.getHttpStatus(), response.getErrorReason());
        }
    }

    public CouchDatabase database(String databaseName) {
        return new CouchDatabaseImpl(databaseName, this.httpClient, this.jsonStrategy, this.metaRepository, CouchFeatureSet.empty());
    }

    public CouchDatabase database(String databaseName, CouchFeatureSet couchFeatureSet) {
        return new CouchDatabaseImpl(databaseName, this.httpClient, this.jsonStrategy, this.metaRepository, couchFeatureSet);
    }
}

