/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.request;

import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.core.api.request.PutRequest;
import org.tiogasolutions.couchace.core.api.response.CouchResponseHandler;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.couchace.core.internal.RequestExecutor;

public class PutEntityRequest
implements PutRequest {
    private final RequestExecutor requestExecutor;
    private final String documentId;
    private final String documentRevision;
    private final String entityType;
    private final Object entity;
    private final CouchAttachmentInfoMap attachmentInfoMap;
    private CouchResponseHandler<WriteResponse> onResponse;
    private CouchResponseHandler<WriteResponse> onSuccess;
    private CouchResponseHandler<WriteResponse> onError;

    public PutEntityRequest(RequestExecutor requestExecutor, String documentId, String entityType, Object entity, String documentRevision, CouchAttachmentInfoMap attachmentInfoMap) {
        this.requestExecutor = requestExecutor;
        this.documentId = documentId;
        this.documentRevision = documentRevision;
        this.entityType = entityType;
        this.entity = entity;
        this.attachmentInfoMap = attachmentInfoMap;
    }

    public PutEntityRequest(RequestExecutor requestExecutor, String documentId, String entityType, Object entity, String documentRevision) {
        this(requestExecutor, documentId, entityType, entity, documentRevision, null);
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentRevision() {
        return this.documentRevision;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Object getEntity() {
        return this.entity;
    }

    public CouchAttachmentInfoMap getAttachmentInfoMap() {
        return this.attachmentInfoMap;
    }

    public Class<?> getEntityClass() {
        return this.entity != null ? this.entity.getClass() : Object.class;
    }

    public WriteResponse execute() {
        return this.requestExecutor.execute(this);
    }

    public PutEntityRequest onResponse(CouchResponseHandler<WriteResponse> onResponse) {
        this.onResponse = onResponse;
        return this;
    }

    public PutEntityRequest onSuccess(CouchResponseHandler<WriteResponse> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public PutEntityRequest onError(CouchResponseHandler<WriteResponse> onError) {
        this.onError = onError;
        return this;
    }

    @Override
    public CouchResponseHandler<WriteResponse> getOnResponse() {
        return this.onResponse;
    }

    @Override
    public CouchResponseHandler<WriteResponse> getOnSuccess() {
        return this.onSuccess;
    }

    @Override
    public CouchResponseHandler<WriteResponse> getOnError() {
        return this.onError;
    }
}

