/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.exceptions;

public class TemplateAssertionException
extends RuntimeException {
    private static final long serialVersionUID = -2261382147273524844L;
    private static final String ASSERTION_MESSAGE = "Assertion '%s' not valid in template '%s'";
    private static final String ASSERTION_MESSAGE_LINE = "Assertion '%s' not valid in template '%s', line %d";

    public TemplateAssertionException(String assertionExpression, String templateName, Integer line) {
        super(TemplateAssertionException.createMessage(assertionExpression, templateName, line));
    }

    public TemplateAssertionException(String assertionExpression, String templateName) {
        super(TemplateAssertionException.createMessage(assertionExpression, templateName, null));
    }

    private static String createMessage(String assertionExpression, String templateName, Integer line) {
        if (line == null) {
            return String.format(ASSERTION_MESSAGE, assertionExpression, templateName);
        }
        return String.format(ASSERTION_MESSAGE_LINE, assertionExpression, templateName, line);
    }
}

