/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.notify.pub.route.Destination;

public class Route {
    private final String name;
    private final String eval;
    private final List<Destination> destinations;

    @JsonCreator
    public Route(@JsonProperty(value="name") String name, @JsonProperty(value="eval") String eval, @JsonProperty(value="destinations") List<Destination> destinations) {
        this.name = name;
        this.eval = eval;
        this.destinations = destinations != null ? Collections.unmodifiableList(destinations) : Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public String getEval() {
        return this.eval;
    }

    public List<Destination> getDestinations() {
        return this.destinations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route route = (Route)o;
        if (!this.destinations.equals(route.destinations)) {
            return false;
        }
        if (this.eval != null ? !this.eval.equals(route.eval) : route.eval != null) {
            return false;
        }
        return this.name.equals(route.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.eval != null ? this.eval.hashCode() : 0);
        result = 31 * result + this.destinations.hashCode();
        return result;
    }

    public String toString() {
        return "Route{name='" + this.name + '\'' + ", eval='" + this.eval + '\'' + ", destinations=" + this.destinations + '}';
    }
}

