/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.runners.grizzly;

import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.core.Application;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzly.LoggerFacade;
import org.tiogasolutions.runners.grizzly.ResourceConfigAdapter;

public class GrizzlyServer {
    private static final int socketAcceptTimeoutMilli = 5000;
    private final GrizzlyServerConfig config;
    private final LoggerFacade logger;
    private final ResourceConfig resourceConfig;
    private HttpServer httpServer;
    private ServerSocket socket;
    private Thread acceptThread;
    private final ReentrantLock handlerLock = new ReentrantLock();

    public GrizzlyServer(Application application, GrizzlyServerConfig config, LoggerFacade logger) {
        this.config = config;
        this.logger = logger;
        this.resourceConfig = application instanceof ResourceConfig ? (ResourceConfig)application : new ResourceConfigAdapter(application);
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public URI getBaseUri() {
        return this.config.getBaseUri();
    }

    public GrizzlyServerConfig getConfig() {
        return this.config;
    }

    public void start() {
        try {
            this.doStart(this.resourceConfig);
            this.logger.info(String.format("Application started at %s", this.getBaseUri()));
            this.logger.info(String.format("WADL available at %sapplication.wadl", this.getBaseUri()));
            if (this.config.isToOpenBrowser()) {
                URI baseUri = this.getBaseUri();
                Desktop.getDesktop().browse(baseUri);
            }
            Thread.currentThread().join();
        }
        catch (Throwable e) {
            this.logger.error("Exception starting server", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart(ResourceConfig resourceConfig) throws Exception {
        GrizzlyServer.shutdownRemote(this.config.getHostName(), this.config.getShutdownPort());
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.config.getBaseUri(), (ResourceConfig)resourceConfig);
        this.lockHandler();
        try {
            if (this.acceptThread != null) {
                throw new IllegalStateException("Socket handler thread is already running.");
            }
            try {
                this.socket = new ServerSocket(this.config.getShutdownPort());
                this.socket.setSoTimeout(5000);
                String msg = String.format("%s is accepting connections on port %s from %s.", this.getClass().getSimpleName(), this.config.getPort(), this.socket.getInetAddress().getHostAddress());
                this.logger.info(msg);
            }
            catch (IOException ex) {
                String msg = String.format("IOException starting server socket, maybe port %s was not available.", this.config.getPort());
                this.logger.error(msg, ex);
            }
            Thread shutdownThread = new Thread(() -> ((HttpServer)this.httpServer).shutdown(), "shutdownHook");
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            Runnable acceptRun = this::socketAcceptLoop;
            this.acceptThread = new Thread(acceptRun);
            this.acceptThread.start();
        }
        finally {
            this.unlockHandler();
        }
    }

    public void shutdownThis() {
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
    }

    public static void shutdownRemote(String hostName, int shutdownPort) throws IOException {
        try (Socket localSocket = new Socket(hostName, shutdownPort);
             OutputStream outStream = localSocket.getOutputStream();){
            outStream.write("SHUTDOWN".getBytes());
            outStream.flush();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    private void lockHandler() throws TimeoutException, InterruptedException {
        int timeout = 5;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if (!this.handlerLock.tryLock(timeout, timeUnit)) {
            String msg = String.format("Failed to obtain lock within %s %s", new Object[]{timeout, timeUnit});
            throw new TimeoutException(msg);
        }
    }

    private void unlockHandler() {
        this.handlerLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void socketAcceptLoop() {
        block7: while (!Thread.interrupted()) {
            try {
                Thread.sleep(5L);
                this.lockHandler();
                if (this.acceptThread == null || Thread.interrupted()) {
                    this.logger.info("Looks like SocketHandler has been stopped, terminate our acceptLoop.");
                    System.out.println("Looks like SocketHandler has been stopped, terminate our acceptLoop.");
                    return;
                }
                Socket client = this.socket.accept();
                StringBuilder builder = new StringBuilder();
                InputStream is = client.getInputStream();
                while (true) {
                    int val;
                    if ((val = is.read()) == -1) continue block7;
                    builder.append((char)val);
                    if (!"SHUTDOWN".equals(builder.toString())) continue;
                    this.logger.info("Shutdown command received.");
                    System.out.println("Shutdown command received.");
                    this.httpServer.shutdownNow();
                    System.exit(0);
                }
            }
            catch (SocketTimeoutException | TimeoutException client) {
            }
            catch (Throwable ex) {
                this.logger.error("Unexpected exception", ex);
                System.out.println("Unexpected exception");
                ex.printStackTrace();
                return;
            }
            finally {
                this.unlockHandler();
            }
        }
    }
}

