/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.CDATASection;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.DOMVisitor;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Macro;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.ProcessorAndContext;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.util.IdentityCounter;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Serializable {
    private static final long serialVersionUID = 3082306990735650683L;
    public static final String NODE_PROPERTY_XML_ENCODING = "XML_ENCODING";
    public static final String NODE_PROPERTY_XML_VERSION = "XML_VERSION";
    public static final String NODE_PROPERTY_XML_STANDALONE = "XML_STANDALONE";
    private final String documentName;
    private final Integer lineNumber;
    NestableNode parent;
    private boolean skippable;
    private boolean processable;
    private boolean precomputed;
    private boolean recomputeProcessorsAfterEachExecution;
    private boolean recomputeProcessorsImmediately;
    private NodeLocalVariablesMap nodeLocalVariables;
    private ArrayList<ProcessorAndContext> processors;
    private HashMap<String, Object> nodeProperties;
    private boolean processTextNodes;
    private boolean processCommentNodes;

    @Deprecated
    public static String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    @Deprecated
    public static String applyDialectPrefix(String name, String dialectPrefix) {
        if (name == null) {
            return null;
        }
        if (StringUtils.isEmptyOrWhitespace(dialectPrefix)) {
            return name;
        }
        return dialectPrefix + ':' + name;
    }

    Node(String documentName, Integer lineNumber) {
        this.documentName = documentName;
        this.lineNumber = lineNumber;
        this.processable = true;
        this.skippable = false;
        this.precomputed = false;
        this.recomputeProcessorsAfterEachExecution = false;
        this.recomputeProcessorsImmediately = false;
        this.nodeLocalVariables = null;
        this.processors = null;
        this.nodeProperties = null;
        this.processTextNodes = false;
        this.processCommentNodes = false;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public final void setNodeProperty(String name, Object value) {
        Validate.notNull(name, "Property name cannot be null");
        if (this.nodeProperties == null) {
            this.nodeProperties = new HashMap(3, 1.0f);
        }
        this.nodeProperties.put(name, value);
    }

    public final boolean hasNodeProperty(String name) {
        Validate.notNull(name, "Property name cannot be null");
        return this.nodeProperties != null && this.nodeProperties.containsKey(name);
    }

    public final Object getNodeProperty(String name) {
        Validate.notNull(name, "Property name cannot be null");
        if (this.nodeProperties == null) {
            return null;
        }
        return this.nodeProperties.get(name);
    }

    public final Set<String> getNodePropertyNames() {
        if (this.nodeProperties == null) {
            return Collections.emptySet();
        }
        return Collections.synchronizedSet(this.nodeProperties.keySet());
    }

    public final Map<String, Object> unsafeGetNodeProperties() {
        return this.nodeProperties;
    }

    public final boolean getProcessTextNodes() {
        return this.processTextNodes;
    }

    public void setProcessTextNodes(boolean processTextNodes) {
        this.processTextNodes = processTextNodes;
    }

    public final boolean getProcessCommentNodes() {
        return this.processCommentNodes;
    }

    public void setProcessCommentNodes(boolean processCommentNodes) {
        this.processCommentNodes = processCommentNodes;
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    public final NestableNode getParent() {
        return this.parent;
    }

    public final void setParent(NestableNode parent) {
        this.parent = parent;
        this.processTextNodes = this.parent.getProcessTextNodes();
        this.processCommentNodes = this.parent.getProcessCommentNodes();
    }

    public final boolean getRecomputeProcessorsAfterEachExecution() {
        return this.recomputeProcessorsAfterEachExecution;
    }

    public final void setRecomputeProcessorsAfterEachExecution(boolean recomputeProcessorsAfterEachExecution) {
        this.recomputeProcessorsAfterEachExecution = recomputeProcessorsAfterEachExecution;
    }

    public final boolean getRecomputeProcessorsImmediately() {
        return this.recomputeProcessorsImmediately;
    }

    public final void setRecomputeProcessorsImmediately(boolean recomputeProcessorsImmediately) {
        this.recomputeProcessorsImmediately = recomputeProcessorsImmediately;
    }

    public final boolean isSkippable() {
        return this.skippable;
    }

    protected final void setSkippable(boolean isSkippable) {
        this.skippable = isSkippable;
        if (!isSkippable && this.hasParent() && this.parent.isSkippable()) {
            this.parent.setSkippable(false);
        }
        this.doAdditionalSkippableComputing(isSkippable);
    }

    abstract void doAdditionalSkippableComputing(boolean var1);

    public final boolean isProcessable() {
        return this.processable;
    }

    public final void setProcessable(boolean processable) {
        this.processable = processable;
        if (processable && this.hasParent() && !this.parent.isProcessable()) {
            this.parent.setProcessable(true);
        }
        this.doAdditionalProcessableComputing(processable);
        if (processable) {
            this.setPrecomputed(false);
        }
    }

    abstract void doAdditionalProcessableComputing(boolean var1);

    final boolean isDetached() {
        if (this instanceof Document) {
            return false;
        }
        return !this.hasParent();
    }

    final boolean isPrecomputed() {
        return this.precomputed;
    }

    final void setPrecomputed(boolean precomputed) {
        this.precomputed = precomputed;
    }

    public final boolean hasNodeLocalVariables() {
        return this.nodeLocalVariables != null && this.nodeLocalVariables.size() > 0;
    }

    public final Set<String> getNodeLocalVariableNames() {
        if (this.nodeLocalVariables == null) {
            return Collections.emptySet();
        }
        return this.nodeLocalVariables.keySet();
    }

    final NodeLocalVariablesMap unsafeGetNodeLocalVariables() {
        return this.nodeLocalVariables;
    }

    public final void setNodeLocalVariable(String name, Object value) {
        if (this.nodeLocalVariables == null) {
            this.nodeLocalVariables = new NodeLocalVariablesMap();
        }
        this.nodeLocalVariables.put(name, value);
    }

    public final void setAllNodeLocalVariables(Map<String, Object> variables) {
        if (variables != null) {
            if (this.nodeLocalVariables == null) {
                this.nodeLocalVariables = new NodeLocalVariablesMap();
            }
            this.nodeLocalVariables.putAll(variables);
        }
    }

    final void unsafeSetNodeLocalVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.nodeLocalVariables = new NodeLocalVariablesMap();
            this.nodeLocalVariables.putAll(variables);
        } else {
            this.nodeLocalVariables = null;
        }
    }

    public final void addAllNonExistingNodeLocalVariables(Map<String, Object> variables) {
        if (variables != null) {
            if (this.nodeLocalVariables == null) {
                this.nodeLocalVariables = new NodeLocalVariablesMap();
                this.nodeLocalVariables.putAll(variables);
            } else {
                for (Map.Entry<String, Object> variablesEntry : variables.entrySet()) {
                    if (this.nodeLocalVariables.containsKey(variablesEntry.getKey())) continue;
                    this.nodeLocalVariables.put(variablesEntry.getKey(), variablesEntry.getValue());
                }
            }
        }
    }

    final void precomputeNode(Configuration configuration) {
        if (!this.isProcessable()) {
            return;
        }
        if (!this.isPrecomputed()) {
            this.processors = configuration.computeProcessorsForNode(this);
            if (this.processors == null || this.processors.size() == 0) {
                this.skippable = true;
            } else {
                this.setSkippable(false);
            }
            this.setPrecomputed(true);
        }
        this.doAdditionalPrecomputeNode(configuration);
    }

    abstract void doAdditionalPrecomputeNode(Configuration var1);

    void processNode(Arguments arguments) {
        if (!this.isProcessable()) {
            return;
        }
        if (!(this instanceof Element) && !(this instanceof Document)) {
            if (!this.processTextNodes && !this.processCommentNodes) {
                return;
            }
            if ((this instanceof Text || this instanceof CDATASection) && !this.processTextNodes) {
                return;
            }
            if (this instanceof Comment && !this.processCommentNodes) {
                return;
            }
            if (this instanceof Macro) {
                return;
            }
        }
        if (this.recomputeProcessorsImmediately || this.recomputeProcessorsAfterEachExecution) {
            this.precomputeNode(arguments.getConfiguration());
            this.recomputeProcessorsImmediately = false;
        }
        if (!this.isPrecomputed()) {
            this.precomputeNode(arguments.getConfiguration());
        }
        if (!this.isSkippable()) {
            Arguments executionArguments;
            Arguments arguments2 = executionArguments = this.nodeLocalVariables != null && this.nodeLocalVariables.size() > 0 ? arguments.addLocalVariables(this.nodeLocalVariables) : arguments;
            if (executionArguments.hasLocalVariables()) {
                this.unsafeSetNodeLocalVariables(executionArguments.getLocalVariables());
            }
            if (!this.isDetached() && this.processors != null && this.processors.size() > 0) {
                IdentityCounter<ProcessorAndContext> alreadyExecuted = new IdentityCounter<ProcessorAndContext>(this.processors.size());
                Arguments processingArguments = executionArguments;
                while (!this.isDetached() && processingArguments != null) {
                    if ((processingArguments = Node.applyNextProcessor(processingArguments, this, alreadyExecuted)) != null) {
                        executionArguments = processingArguments;
                    }
                    if (!this.recomputeProcessorsImmediately && !this.recomputeProcessorsAfterEachExecution) continue;
                    this.setPrecomputed(false);
                    this.precomputeNode(arguments.getConfiguration());
                    this.recomputeProcessorsImmediately = false;
                }
            }
            this.doAdditionalProcess(executionArguments);
        }
    }

    private static Arguments applyNextProcessor(Arguments arguments, Node node, IdentityCounter<ProcessorAndContext> alreadyExecuted) {
        if (!node.isDetached() && node.processors != null && node.processors.size() > 0) {
            for (ProcessorAndContext processor : node.processors) {
                int nodeLocalVariablesHashAfter;
                if (alreadyExecuted.isAlreadyCounted(processor)) continue;
                Arguments executionArguments = arguments;
                int nodeLocalVariablesHashBefore = node.nodeLocalVariables == null ? -1 : node.nodeLocalVariables.contentsHash();
                ProcessorResult processorResult = processor.getProcessor().process(executionArguments, processor.getContext(), node);
                int n = nodeLocalVariablesHashAfter = node.nodeLocalVariables == null ? -1 : node.nodeLocalVariables.contentsHash();
                if (nodeLocalVariablesHashBefore != nodeLocalVariablesHashAfter) {
                    executionArguments = executionArguments.addLocalVariables(node.nodeLocalVariables);
                }
                executionArguments = processorResult.computeNewArguments(executionArguments);
                if (processorResult.isProcessTextNodesSet()) {
                    node.setProcessTextNodes(processorResult.getProcessTextNodes());
                }
                if (processorResult.isProcessCommentNodesSet()) {
                    node.setProcessCommentNodes(processorResult.getProcessCommentNodes());
                }
                if ((processorResult.hasLocalVariables() || processorResult.isSelectionTargetSet()) && executionArguments.hasLocalVariables()) {
                    node.unsafeSetNodeLocalVariables(executionArguments.getLocalVariables());
                }
                alreadyExecuted.count(processor);
                return executionArguments;
            }
        }
        return null;
    }

    abstract void doAdditionalProcess(Arguments var1);

    public final Node cloneNode(NestableNode newParent, boolean cloneProcessors) {
        Node clone = this.createClonedInstance(newParent, cloneProcessors);
        this.cloneNodeInternals(clone, newParent, cloneProcessors);
        return clone;
    }

    abstract Node createClonedInstance(NestableNode var1, boolean var2);

    final void cloneNodeInternals(Node node, NestableNode newParent, boolean cloneProcessors) {
        this.doCloneNodeInternals(node, newParent, cloneProcessors);
        if (cloneProcessors) {
            node.processors = this.processors;
            node.skippable = this.skippable;
            node.precomputed = this.precomputed;
        } else {
            node.processors = null;
            node.skippable = false;
            node.precomputed = false;
        }
        node.parent = newParent;
        if (this.nodeLocalVariables != null) {
            node.nodeLocalVariables = new NodeLocalVariablesMap();
            node.nodeLocalVariables.putAll(this.nodeLocalVariables);
        }
        if (this.nodeProperties != null) {
            node.nodeProperties = new HashMap<String, Object>(this.nodeProperties);
        }
        node.processTextNodes = this.processTextNodes;
        node.processCommentNodes = this.processCommentNodes;
    }

    abstract void doCloneNodeInternals(Node var1, NestableNode var2, boolean var3);

    public abstract void visit(DOMVisitor var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeLocalVariablesMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 4632571067579619256L;
        public static final int DEFAULT_NODE_LOCAL_VARIABLES_MAP_SIZE = 3;

        public NodeLocalVariablesMap() {
            super(3);
        }

        int contentsHash() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + System.identityHashCode(this);
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                result = 31 * result + (key == null ? 0 : System.identityHashCode(key));
                result = 31 * result + (value == null ? 0 : System.identityHashCode(value));
            }
            return result;
        }

        @Override
        public NodeLocalVariablesMap clone() {
            return (NodeLocalVariablesMap)super.clone();
        }
    }
}

