/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfo;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.notify.kernel.notification.CreateNotification;
import org.tiogasolutions.notify.pub.attachment.AttachmentInfo;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.common.Link;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationRef;

@CouchEntity(value="Notification")
public class NotificationEntity {
    private final String notificationId;
    private String revision;
    private final String domainName;
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final List<Link> links;
    private final ExceptionInfo exceptionInfo;
    private CouchAttachmentInfoMap attachmentInfoMap;

    public static NotificationEntity newEntity(String domainName, CreateNotification create) {
        return new NotificationEntity(domainName, TimeUuid.randomUUID().toString(), null, create.getTopic(), create.getSummary(), create.getTrackingId(), create.getCreatedAt(), create.getTraitMap(), create.getLinks(), create.getExceptionInfo());
    }

    @JsonCreator
    public NotificationEntity(@JsonProperty(value="domainName") String domainName, @JsonProperty(value="notificationId") String notificationId, @JsonProperty(value="revision") String revision, @JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="traitMap") Map<String, String> traitMap, @JsonProperty(value="links") List<Link> links, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo) {
        this.domainName = domainName;
        this.notificationId = notificationId;
        this.revision = revision;
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt != null ? createdAt : ZonedDateTime.now();
        this.links = links != null ? Collections.unmodifiableList(links) : null;
        this.exceptionInfo = exceptionInfo;
        this.traitMap = traitMap != null ? Collections.unmodifiableMap(traitMap) : Collections.emptyMap();
    }

    public NotificationRef toNotificationRef() {
        return new NotificationRef(this.domainName, this.notificationId, this.revision);
    }

    public Notification toNotification() {
        return new Notification(null, this.domainName, this.notificationId, this.revision, this.topic, this.summary, this.trackingId, this.createdAt, this.traitMap, this.links, this.exceptionInfo, this.listAttachmentInfo());
    }

    public Notification toNotificationWithRevision(String revisionArg) {
        return new Notification(null, this.domainName, this.notificationId, revisionArg, this.topic, this.summary, this.trackingId, this.createdAt, this.traitMap, this.links, this.exceptionInfo, this.listAttachmentInfo());
    }

    @CouchId
    public String getNotificationId() {
        return this.notificationId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<AttachmentInfo> listAttachmentInfo() {
        ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>();
        if (this.attachmentInfoMap != null) {
            for (Map.Entry entry : this.attachmentInfoMap.entrySet()) {
                AttachmentInfo attachInfo = new AttachmentInfo((String)entry.getKey(), ((CouchAttachmentInfo)entry.getValue()).getContentType());
                attachmentInfoList.add(attachInfo);
            }
        }
        return attachmentInfoList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationEntity that = (NotificationEntity)o;
        if (this.attachmentInfoMap != null ? !this.attachmentInfoMap.equals(that.attachmentInfoMap) : that.attachmentInfoMap != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) {
            return false;
        }
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals((Object)that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.notificationId != null ? !this.notificationId.equals(that.notificationId) : that.notificationId != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.trackingId != null ? !this.trackingId.equals(that.trackingId) : that.trackingId != null) {
            return false;
        }
        return !(this.traitMap != null ? !this.traitMap.equals(that.traitMap) : that.traitMap != null);
    }

    public int hashCode() {
        int result = this.notificationId != null ? this.notificationId.hashCode() : 0;
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.trackingId != null ? this.trackingId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.traitMap != null ? this.traitMap.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        result = 31 * result + (this.attachmentInfoMap != null ? this.attachmentInfoMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NotificationEntity{notificationId='" + this.notificationId + '\'' + ", revision='" + this.revision + '\'' + ", domainName='" + this.domainName + '\'' + ", topic='" + this.topic + '\'' + ", summary='" + this.summary + '\'' + ", trackingId='" + this.trackingId + '\'' + ", createdAt=" + this.createdAt + ", traitMap=" + this.traitMap + ", links=" + this.links + ", exceptionInfo=" + this.exceptionInfo + ", attachmentInfoMap=" + this.attachmentInfoMap + '}';
    }
}

