/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub.common;

import java.io.Serializable;
import org.tiogasolutions.dev.common.StringUtils;

public enum CellularType implements Serializable
{
    Alltel("Alltel", "@message.alltel.com"),
    ATT("AT&T", "@txt.att.net"),
    Cingular("Cingular", "@cingularme.com"),
    MetroPCS("Metro PCS", "@MyMetroPcs.com"),
    Nextel("Nextel", "@messaging.nextel.com"),
    Powertel("Powertel", "@ptel.net"),
    Sprint("Sprint", "@messaging.sprintpcs.com"),
    SunCom("SunCom", "@tms.suncom.com"),
    TMobile("T-Mobile", "@tmomail.net"),
    USCellular("US Cellular", "@email.uscc.net"),
    Verizon("Verizon", "@vtext.com"),
    VirginMobile("Virgin Mobile", "@vmobl.com"),
    Cricket("Cricket", "@mms.mycricket.com");

    private final String company;
    private final String emailRight;

    private CellularType(String company, String emailRight) {
        this.company = company;
        this.emailRight = emailRight;
    }

    public String getName() {
        return this.name();
    }

    public String getCompany() {
        return this.company;
    }

    public String getEmailRight() {
        return this.emailRight;
    }

    public static String emailToPhoneNumber(String address) {
        if (StringUtils.isBlank((Object)address)) {
            return null;
        }
        int pos = address.indexOf("@");
        if (pos < 0) {
            return address;
        }
        return address.substring(0, pos);
    }

    public static CellularType emailToCellularType(String address) {
        if (StringUtils.isBlank((Object)address)) {
            return null;
        }
        int pos = address.indexOf("@");
        if (pos < 0) {
            return null;
        }
        String value = address.substring(pos);
        for (CellularType cellularType : CellularType.values()) {
            if (!cellularType.getEmailRight().equals(value)) continue;
            return cellularType;
        }
        return null;
    }
}

