/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.query;

import org.tiogasolutions.couchace.core.internal.util.ArgUtil;

public class CouchPageQuery {
    private final int pageSize;
    private final String requestedPage;
    private final String currentPage;
    private final boolean includeDocs;

    public CouchPageQuery(int pageSize, String requestedPage, String currentPage, boolean includeDocs) {
        ArgUtil.assertNotNull(requestedPage, "requestedPage");
        this.pageSize = pageSize;
        this.requestedPage = requestedPage;
        this.currentPage = currentPage;
        this.includeDocs = includeDocs;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getRequestedPage() {
        return this.requestedPage;
    }

    public String getCurrentPage() {
        return this.currentPage;
    }

    public boolean isForward() {
        return !this.isReverse();
    }

    public boolean isReverse() {
        return this.requestedPage.contains("descending=true");
    }

    public boolean isIncludeDocs() {
        return this.includeDocs;
    }
}

