/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api;

import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;

public class CouchException
extends RuntimeException {
    private final CouchHttpStatus statusCode;

    public static CouchException conflict(String message) {
        return new CouchException(CouchHttpStatus.CONFLICT, message);
    }

    public static CouchException conflict(Throwable ex) {
        return new CouchException(CouchHttpStatus.CONFLICT, ex);
    }

    public static CouchException conflict(String message, Throwable ex) {
        return new CouchException(CouchHttpStatus.CONFLICT, message, ex);
    }

    public static CouchException notFound(String message) {
        return new CouchException(CouchHttpStatus.NOT_FOUND, message);
    }

    public static CouchException notFound(Throwable ex) {
        return new CouchException(CouchHttpStatus.NOT_FOUND, ex);
    }

    public static CouchException notFound(String message, Throwable ex) {
        return new CouchException(CouchHttpStatus.NOT_FOUND, message, ex);
    }

    public static CouchException badRequest(String message) {
        return new CouchException(CouchHttpStatus.BAD_REQUEST, message);
    }

    public static CouchException internalServerError(Throwable ex) {
        return new CouchException(CouchHttpStatus.INTERNAL_SERVER_ERROR, ex);
    }

    public static CouchException internalServerError(String message) {
        return new CouchException(CouchHttpStatus.INTERNAL_SERVER_ERROR, message);
    }

    public static CouchException internalServerError(String message, Throwable ex) {
        return new CouchException(CouchHttpStatus.INTERNAL_SERVER_ERROR, message, ex);
    }

    public static CouchException serviceUnavailable(String message, Throwable ex) {
        return new CouchException(CouchHttpStatus.SERVICE_UNAVAILABLE, message, ex);
    }

    public static CouchException serviceUnavailable(String message) {
        return new CouchException(CouchHttpStatus.SERVICE_UNAVAILABLE, message);
    }

    public static CouchException serviceUnavailable(Throwable ex) {
        return new CouchException(CouchHttpStatus.SERVICE_UNAVAILABLE, ex);
    }

    public static CouchException forbidden(String message, Throwable ex) {
        return new CouchException(CouchHttpStatus.FORBIDDEN, message, ex);
    }

    public static CouchException forbidden(String message) {
        return new CouchException(CouchHttpStatus.FORBIDDEN, message);
    }

    public static CouchException forbidden(Throwable ex) {
        return new CouchException(CouchHttpStatus.FORBIDDEN, ex);
    }

    public CouchException(CouchHttpStatus statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public CouchException(CouchHttpStatus statusCode) {
        this(statusCode, statusCode.getReason());
    }

    public CouchException(CouchHttpStatus statusCode, String message, Throwable throwable) {
        super(message, throwable);
        this.statusCode = statusCode;
    }

    public CouchException(CouchHttpStatus statusCode, Throwable throwable) {
        super(throwable);
        this.statusCode = statusCode;
    }

    public CouchException(int statusCode) {
        this(CouchHttpStatus.findByCode(statusCode));
    }

    public CouchException(int statusCode, String message) {
        this(CouchHttpStatus.findByCode(statusCode), message);
    }

    public CouchException(int statusCode, String message, Throwable throwable) {
        this(CouchHttpStatus.findByCode(statusCode), message, throwable);
    }

    public CouchException(int statusCode, Throwable throwable) {
        this(CouchHttpStatus.findByCode(statusCode), throwable);
    }

    public CouchHttpStatus getHttpStatus() {
        return this.statusCode;
    }

    public int getHttpStatusCode() {
        return this.statusCode.getCode();
    }
}

