/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.jackson.msg;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.fine.FineMessage;
import org.tiogasolutions.dev.common.fine.FineMessageSet;
import org.tiogasolutions.dev.common.fine.FineMessageSetBuilder;

public final class FineMessageSetDeserializer
extends StdDeserializer<FineMessageSet> {
    public FineMessageSetDeserializer() {
        super(FineMessageSet.class);
    }

    public FineMessageSet deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        FineMessageSetBuilder builder = new FineMessageSetBuilder();
        parser.nextToken();
        String name = parser.getCurrentName();
        parser.nextToken();
        if ("messages".equals(name)) {
            parser.nextToken();
            Iterator it = parser.readValuesAs(FineMessage.class);
            while (it.hasNext()) {
                builder.withMessage((FineMessage)it.next());
            }
        } else {
            throw ApiException.internalServerError((String)("Error during RichMessageSet translation, expecting \"message\" but node is " + name), (String[])new String[0]);
        }
        return builder.build();
    }
}

