/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.couchace.app;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.StringWriter;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;

@CouchEntity(value="app-config")
public class AppConfig {
    private String revision;
    private String appConfigId;
    private String[] properties;

    @JsonCreator
    public AppConfig(@JsonProperty(value="appConfigId") String appConfigId, @JsonProperty(value="revision") String revision, @JsonProperty(value="properties") String[] properties) {
        this.appConfigId = appConfigId;
        this.revision = revision;
        this.properties = properties;
    }

    @CouchId
    public String getAppConfigId() {
        return this.appConfigId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public String getProperty(String propertyName) {
        for (String property : this.properties) {
            String key = propertyName + "=";
            if (!property.startsWith(key)) continue;
            return property.substring(key.length());
        }
        return null;
    }

    @JsonIgnore
    public String getPropertyString() {
        StringWriter writer = new StringWriter();
        for (String property : this.properties) {
            writer.write(property);
            writer.write("\n");
        }
        return writer.toString();
    }
}

