/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.InetAddress;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.PushType;
import org.tiogasolutions.push.pub.internal.PushUtils;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.lqnotify.LqAttachment;
import org.tiogasolutions.push.pub.lqnotify.LqExceptionInfo;

public class LqNotificationPush
implements Push,
Serializable {
    public static final PushType PUSH_TYPE = new PushType(LqNotificationPush.class, "liquid-notification", "Lq Notification");
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final LqExceptionInfo exceptionInfo;
    private final Map<String, String> traits = new HashMap<String, String>();
    private final List<LqAttachment> attachments = new ArrayList<LqAttachment>();
    private final String remoteHost;
    private final String remoteAddress;
    private final String callbackUrl;

    @JsonCreator
    private LqNotificationPush(@JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="exceptionInfo") LqExceptionInfo exceptionInfo, @JsonProperty(value="attachmentsArg") Collection<LqAttachment> attachments, @JsonProperty(value="callbackUrl") String callbackUrl, @JsonProperty(value="remoteHost") String remoteHost, @JsonProperty(value="remoteAddress") String remoteAddress, @JsonProperty(value="traits") Map<String, String> traits) {
        String[] keys;
        this.topic = topic != null ? topic : "none";
        this.summary = summary != null ? summary : "none";
        this.trackingId = trackingId;
        this.exceptionInfo = exceptionInfo;
        ZonedDateTime zonedDateTime = this.createdAt = createdAt != null ? createdAt : ZonedDateTime.now();
        if (traits != null) {
            this.traits.putAll(traits);
        }
        if (attachments != null) {
            this.attachments.addAll(attachments);
        }
        this.remoteHost = remoteHost;
        this.remoteAddress = remoteAddress;
        this.callbackUrl = callbackUrl;
        for (String key : keys = (String[])ReflectUtils.toArray(String.class, this.traits.keySet())) {
            if (!StringUtils.isBlank((Object)this.traits.get(key))) continue;
            this.traits.remove(key);
        }
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Override
    public PushType getPushType() {
        return PUSH_TYPE;
    }

    @Override
    public Map<String, String> getTraits() {
        return this.traits;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LqExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<LqAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public RequestErrors validate(RequestErrors errors) {
        return errors;
    }

    @Deprecated
    public static LqNotificationPush newPushV1(String summary, String callbackUrl, String remoteHost, String remoteAddress, Map<String, String> traits) {
        return new LqNotificationPush("unit-test", summary, null, ZonedDateTime.now(), null, Collections.emptyList(), callbackUrl, remoteHost, remoteAddress, traits);
    }

    public static LqNotificationPush newPush(String topic, String summary, String trackingId, String callbackUrl, String ... traits) {
        return LqNotificationPush.newPush(topic, summary, trackingId, null, Collections.emptyList(), callbackUrl, BeanUtils.toMap((String[])traits));
    }

    public static LqNotificationPush newPush(String topic, String summary, String trackingId, String callbackUrl, Map<String, String> traits) {
        return LqNotificationPush.newPush(topic, summary, trackingId, null, Collections.emptyList(), callbackUrl, traits);
    }

    public static LqNotificationPush newPush(String topic, String summary, String trackingId, Throwable throwable, String callbackUrl, String ... traits) {
        return LqNotificationPush.newPush(topic, summary, trackingId, throwable, Collections.emptyList(), callbackUrl, BeanUtils.toMap((String[])traits));
    }

    public static LqNotificationPush newPush(String topic, String summary, String trackingId, Throwable throwable, String callbackUrl, Map<String, String> traits) {
        return LqNotificationPush.newPush(topic, summary, trackingId, throwable, Collections.emptyList(), callbackUrl, traits);
    }

    public static LqNotificationPush newPush(String topic, String summary, String trackingId, Throwable throwable, Collection<LqAttachment> attachments, String callbackUrl, String ... traits) {
        return LqNotificationPush.newPush(topic, summary, trackingId, throwable, attachments, callbackUrl, BeanUtils.toMap((String[])traits));
    }

    public static LqNotificationPush newPush(String topic, String summary, String trackingId, Throwable throwable, Collection<LqAttachment> attachments, String callbackUrl, Map<String, String> traits) {
        InetAddress remoteAddress = PushUtils.getLocalHost();
        LqExceptionInfo exceptionInfo = throwable == null ? null : LqExceptionInfo.create(throwable);
        return new LqNotificationPush(topic, summary, trackingId, ZonedDateTime.now(), exceptionInfo, attachments, callbackUrl, remoteAddress.getCanonicalHostName(), remoteAddress.getHostAddress(), traits);
    }
}

