/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.pub.attachment.AttachmentInfo;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.common.Link;
import org.tiogasolutions.notify.pub.request.NotificationRequestStatus;

public class NotificationRequest {
    private final String requestId;
    private final String revision;
    private final NotificationRequestStatus requestStatus;
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final List<Link> links;
    private final ExceptionInfo exceptionInfo;
    private final List<AttachmentInfo> attachmentInfoList;

    @JsonCreator
    public NotificationRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="revision") String revision, @JsonProperty(value="requestStatus") NotificationRequestStatus requestStatus, @JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="traitMap") Map<String, String> traitMap, @JsonProperty(value="links") List<Link> links, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo, @JsonProperty(value="attachmentInfoList") List<AttachmentInfo> attachmentInfoList) {
        this.requestId = requestId;
        this.revision = revision;
        this.requestStatus = requestStatus;
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt;
        this.exceptionInfo = exceptionInfo;
        this.links = links != null ? Collections.unmodifiableList(links) : Collections.emptyList();
        this.traitMap = traitMap != null ? Collections.unmodifiableMap(traitMap) : Collections.emptyMap();
        this.attachmentInfoList = attachmentInfoList != null ? Collections.unmodifiableList(attachmentInfoList) : Collections.emptyList();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRevision() {
        return this.revision;
    }

    public NotificationRequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<AttachmentInfo> getAttachmentInfoList() {
        return this.attachmentInfoList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRequest that = (NotificationRequest)o;
        if (!this.attachmentInfoList.equals(that.attachmentInfoList)) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals(that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        if (!this.links.equals(that.links)) {
            return false;
        }
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        if (this.requestStatus != that.requestStatus) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.trackingId != null ? !this.trackingId.equals(that.trackingId) : that.trackingId != null) {
            return false;
        }
        return this.traitMap.equals(that.traitMap);
    }

    public int hashCode() {
        int result = this.requestId != null ? this.requestId.hashCode() : 0;
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.requestStatus != null ? this.requestStatus.hashCode() : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.trackingId != null ? this.trackingId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + this.traitMap.hashCode();
        result = 31 * result + this.links.hashCode();
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        result = 31 * result + this.attachmentInfoList.hashCode();
        return result;
    }
}

