/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.util.Map;
import org.tiogasolutions.couchace.core.internal.util.CouchJsonUtil;
import org.tiogasolutions.couchace.core.internal.util.StringUtil;

public final class CouchErrorContent {
    private final String error;
    private final String reason;
    public static final CouchErrorContent noError = new CouchErrorContent("none", "No error");
    public static final CouchErrorContent undefined = new CouchErrorContent("undefined", "No reason specified");

    public static CouchErrorContent parseJson(String json) {
        try {
            if (StringUtil.isBlank(json)) {
                return noError;
            }
            if (!json.startsWith("{") || !json.endsWith("}")) {
                return new CouchErrorContent(json, json);
            }
            Map<String, String> jsonMap = CouchJsonUtil.parseJson(json);
            String error = jsonMap.get("error");
            String reason = jsonMap.get("reason");
            if (error == null && reason == null) {
                error = json;
                reason = json;
            }
            return new CouchErrorContent(error, reason);
        }
        catch (Throwable e) {
            return new CouchErrorContent("undefined", "Error parsing error content: " + e.getMessage());
        }
    }

    public CouchErrorContent(String error, String reason) {
        this.error = error;
        this.reason = reason;
    }

    public String toJson() {
        return String.format("{\"error\" : \"%s\",\"reason\" : \"%s\"}", this.error, this.reason);
    }

    public boolean isNoError() {
        return this.equals(noError);
    }

    public String getError() {
        return this.error;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouchErrorContent that = (CouchErrorContent)o;
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        return !(this.reason != null ? !this.reason.equals(that.reason) : that.reason != null);
    }

    public int hashCode() {
        int result = this.error != null ? this.error.hashCode() : 0;
        result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CouchErrorContent{error='" + this.error + '\'' + ", reason='" + this.reason + '\'' + '}';
    }
}

