/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.route;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.kernel.route.RouteEvaluator;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.route.Route;
import org.tiogasolutions.notify.pub.route.RouteCatalog;

public class JsRouteEvaluator
implements RouteEvaluator {
    private final List<RouteMatcher> routeMatcherList;
    private final ScriptEngine engine;
    private final Invocable invocable;

    public JsRouteEvaluator(RouteCatalog routeCatalog) {
        List routes = routeCatalog.loadActiveRoutes();
        this.routeMatcherList = new ArrayList<RouteMatcher>();
        ScriptEngineManager engineManager = new ScriptEngineManager();
        this.engine = engineManager.getEngineByName("nashorn");
        this.invocable = (Invocable)((Object)this.engine);
        this.routeMatcherList.addAll(routes.stream().map(arg_0 -> RouteMatcher.new(this, arg_0)).collect(Collectors.toList()));
    }

    @Override
    public Set<Destination> findDestinations(Notification notification) {
        HashSet<Destination> destinations = new HashSet<Destination>();
        this.routeMatcherList.stream().filter(matcher -> matcher.isMatch(notification)).forEach(matcher -> destinations.addAll(((RouteMatcher)matcher).route.getDestinations()));
        return destinations;
    }

    public class RouteMatcher {
        private final Route route;
        private final String jsFunc;

        public RouteMatcher(Route route) {
            this.route = route;
            this.jsFunc = String.format("var eval = %s", route.getEval());
        }

        public boolean isMatch(Notification notification) {
            try {
                JsRouteEvaluator.this.engine.eval(this.jsFunc);
                return (Boolean)JsRouteEvaluator.this.invocable.invokeFunction("eval", notification.getTopic(), notification.getTraitMap());
            }
            catch (NoSuchMethodException | ScriptException e) {
                throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
            }
        }
    }
}

