/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementAndAttributeNameFragmentSpec
implements IFragmentSpec {
    private final String elementName;
    private final String attributeName;
    private final String attributeValue;
    private final boolean returnOnlyChildren;
    private final Map<String, Object> parameterValues;

    public ElementAndAttributeNameFragmentSpec(String elementName, String attributeName, String attributeValue) {
        this(elementName, attributeName, attributeValue, null, false);
    }

    public ElementAndAttributeNameFragmentSpec(String elementName, String attributeName, String attributeValue, Map<String, Object> parameterValues) {
        this(elementName, attributeName, attributeValue, parameterValues, false);
    }

    public ElementAndAttributeNameFragmentSpec(String elementName, String attributeName, String attributeValue, boolean returnOnlyChildren) {
        this(elementName, attributeName, attributeValue, null, returnOnlyChildren);
    }

    public ElementAndAttributeNameFragmentSpec(String elementName, String attributeName, String attributeValue, Map<String, Object> parameterValues, boolean returnOnlyChildren) {
        Validate.isTrue(!StringUtils.isEmptyOrWhitespace(elementName) || !StringUtils.isEmptyOrWhitespace(attributeName), "Either element name of attribute name must not be null or empty");
        if (!StringUtils.isEmptyOrWhitespace(attributeName)) {
            Validate.notEmpty(attributeValue, "Fragment attribute value cannot be null or empty");
        }
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.parameterValues = parameterValues;
        this.returnOnlyChildren = returnOnlyChildren;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public boolean isReturnOnlyChildren() {
        return this.returnOnlyChildren;
    }

    public Map<String, Object> getParameterValues() {
        return Collections.unmodifiableMap(this.parameterValues);
    }

    public boolean hasParameterValues() {
        return this.parameterValues != null && this.parameterValues.size() > 0;
    }

    @Override
    public List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        List<Node> extraction = DOMUtils.extractFragmentByElementAndAttributeValue(nodes, this.elementName, this.attributeName, this.attributeValue);
        if (!this.returnOnlyChildren) {
            ElementAndAttributeNameFragmentSpec.applyParameters(extraction, this.parameterValues);
            return extraction;
        }
        ArrayList<Node> extractionChildren = new ArrayList<Node>(5);
        for (Node extractionNode : extraction) {
            if (extractionNode == null) continue;
            if (!(extractionNode instanceof NestableNode)) {
                throw new TemplateProcessingException("Cannot correctly retrieve children of node selected by fragment spec with element name \"" + this.elementName + "\", attribute name \"" + this.attributeName + "\" and attribute value \"" + this.attributeValue + "\". Node is not a nestable node (" + extractionNode.getClass().getSimpleName() + ").");
            }
            extractionChildren.addAll(((NestableNode)extractionNode).getChildren());
        }
        ElementAndAttributeNameFragmentSpec.applyParameters(extractionChildren, this.parameterValues);
        return extractionChildren;
    }

    private static void applyParameters(List<Node> nodes, Map<String, Object> parameterValues) {
        for (Node node : nodes) {
            node.setAllNodeLocalVariables(parameterValues);
        }
    }

    public String toString() {
        return "(ELEMENT: " + this.elementName + " | ATTRIBUTE: " + this.attributeName + "=\"" + this.attributeValue + "\")";
    }
}

