/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.context.AbstractDialectAwareProcessingContext;
import org.thymeleaf.dialect.IExpressionEnhancingDialect;
import org.thymeleaf.dom.Document;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Arguments
extends AbstractDialectAwareProcessingContext {
    private final TemplateEngine templateEngine;
    private final TemplateProcessingParameters templateProcessingParameters;
    private final Configuration configuration;
    private final Document document;
    private final TemplateResolution templateResolution;
    private final TemplateRepository templateRepository;
    private final Map<String, Integer> idCounts;

    public Arguments(TemplateEngine templateEngine, TemplateProcessingParameters templateProcessingParameters, TemplateResolution templateResolution, TemplateRepository templateRepository, Document document) {
        super(templateProcessingParameters == null ? null : templateProcessingParameters.getContext(), templateProcessingParameters == null ? null : templateProcessingParameters.getProcessingContext().getLocalVariables(), templateProcessingParameters == null ? null : templateProcessingParameters.getProcessingContext().getSelectionTarget(), templateProcessingParameters != null && templateProcessingParameters.getProcessingContext().hasSelectionTarget(), templateProcessingParameters == null ? null : templateProcessingParameters.getConfiguration().getDialectSet());
        Validate.notNull(templateEngine, "Template engine cannot be null");
        Validate.notNull(templateProcessingParameters, "Template processing parameters cannot be null");
        Validate.notNull(templateResolution, "Template resolution cannot be null");
        Validate.notNull(templateRepository, "Template repository cannot be null");
        this.templateEngine = templateEngine;
        this.templateProcessingParameters = templateProcessingParameters;
        this.configuration = this.templateProcessingParameters == null ? null : this.templateProcessingParameters.getConfiguration();
        this.templateResolution = templateResolution;
        this.templateRepository = templateRepository;
        this.document = document;
        this.idCounts = new HashMap<String, Integer>(1, 1.0f);
    }

    private Arguments(TemplateEngine templateEngine, TemplateProcessingParameters templateProcessingParameters, TemplateResolution templateResolution, TemplateRepository templateRepository, Document document, Map<String, Object> localVariables, Map<String, Integer> idCounts, Object selectionTarget, boolean selectionTargetSet, Set<IExpressionEnhancingDialect> enhancingDialects) {
        super(templateProcessingParameters == null ? null : templateProcessingParameters.getContext(), localVariables, selectionTarget, selectionTargetSet, enhancingDialects);
        this.templateEngine = templateEngine;
        this.templateProcessingParameters = templateProcessingParameters;
        this.configuration = this.templateProcessingParameters == null ? null : this.templateProcessingParameters.getConfiguration();
        this.templateResolution = templateResolution;
        this.templateRepository = templateRepository;
        this.document = document;
        this.idCounts = idCounts;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public TemplateProcessingParameters getTemplateProcessingParameters() {
        return this.templateProcessingParameters;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TemplateResolution getTemplateResolution() {
        return this.templateResolution;
    }

    public TemplateRepository getTemplateRepository() {
        return this.templateRepository;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getTemplateName() {
        return this.templateResolution.getTemplateName();
    }

    public Map<String, Integer> getIdCounts() {
        return this.idCounts;
    }

    public Map<String, Object> getExecutionAttributes() {
        return this.configuration.getExecutionAttributes();
    }

    public Object getExecutionAttribute(String attributeName) {
        return this.configuration.getExecutionAttributes().get(attributeName);
    }

    public Integer getAndIncrementIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            count = 1;
        }
        this.idCounts.put(id, count + 1);
        return count;
    }

    public Integer getNextIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            count = 1;
        }
        return count;
    }

    public Integer getPreviousIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            throw new TemplateProcessingException("Cannot obtain previous ID count for ID \"" + id + "\"");
        }
        return count - 1;
    }

    public Arguments addLocalVariables(Map<String, Object> newVariables) {
        if (newVariables == null || newVariables.isEmpty()) {
            return this;
        }
        return new Arguments(this.templateEngine, this.templateProcessingParameters, this.templateResolution, this.templateRepository, this.document, this.mergeNewLocalVariables(newVariables), this.idCounts, this.getSelectionTarget(), this.hasSelectionTarget(), this.getExpressionEnhancingDialects());
    }

    public Arguments setSelectionTarget(Object newSelectionTarget) {
        return new Arguments(this.templateEngine, this.templateProcessingParameters, this.templateResolution, this.templateRepository, this.document, this.getLocalVariables(), this.idCounts, newSelectionTarget, true, this.getExpressionEnhancingDialects());
    }

    public Arguments addLocalVariablesAndSelectionTarget(Map<String, Object> newVariables, Object selectionTarget) {
        return new Arguments(this.templateEngine, this.templateProcessingParameters, this.templateResolution, this.templateRepository, this.document, this.mergeNewLocalVariables(newVariables), this.idCounts, selectionTarget, true, this.getExpressionEnhancingDialects());
    }
}

