/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.core.env.Environment;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.couchace.core.api.CouchSetup;
import org.tiogasolutions.couchace.core.api.request.CouchFeature;
import org.tiogasolutions.couchace.core.api.request.CouchFeatureSet;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.couchace.core.internal.util.StringUtil;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;
import org.tiogasolutions.couchace.jackson.JacksonCouchJsonStrategy;
import org.tiogasolutions.couchace.jersey.JerseyCouchHttpClient;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.kernel.config.CouchServersConfig;
import org.tiogasolutions.notify.kernel.jackson.NotifyKernelJacksonModule;

@Named
public class CouchServers {
    private final Environment environment;
    private final CouchServersConfig serversConfig;
    private final CouchServer masterServer;
    private final CouchDatabase masterDatabase;
    private final CouchServer notificationServer;
    private final String notificationDatabasePrefix;
    private final String notificationDatabaseSuffix;
    private final CouchServer requestServer;
    private final String requestDatabasePrefix;
    private final String requestDatabaseSuffix;

    @Inject
    public CouchServers(Environment environment, CouchServersConfig serversConfig) {
        this.environment = environment;
        this.serversConfig = serversConfig;
        this.notificationDatabasePrefix = serversConfig.getNotificationDatabasePrefix();
        this.notificationDatabaseSuffix = serversConfig.getNotificationDatabaseSuffix();
        this.requestDatabasePrefix = serversConfig.getRequestDatabasePrefix();
        this.requestDatabaseSuffix = serversConfig.getRequestDatabaseSuffix();
        JacksonCouchJsonStrategy jsonStrategy = new JacksonCouchJsonStrategy(new Module[]{new JSR310Module(), new NotifyKernelJacksonModule()});
        CouchSetup masterConfig = new CouchSetup(serversConfig.getMasterUrl()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)jsonStrategy).setUserName(serversConfig.getMasterUserName()).setPassword(serversConfig.getMasterPassword());
        this.masterServer = new CouchServer(masterConfig);
        this.masterDatabase = this.initMasterDatabase(serversConfig, this.masterServer);
        CouchSetup notificationConfig = new CouchSetup(serversConfig.getNotificationUrl()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)jsonStrategy).setUserName(serversConfig.getNotificationUserName()).setPassword(serversConfig.getNotificationPassword());
        this.notificationServer = new CouchServer(notificationConfig);
        CouchSetup requestConfig = new CouchSetup(serversConfig.getRequestUrl()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)jsonStrategy).setUserName(serversConfig.getRequestUserName()).setPassword(serversConfig.getRequestPassword());
        this.requestServer = new CouchServer(requestConfig);
    }

    private CouchDatabase initMasterDatabase(CouchServersConfig serversConfig, CouchServer masterServer) {
        CouchDatabase localMasterDatabase;
        if (this.isTestEnvironment()) {
            CouchFeatureSet featureSet = CouchFeatureSet.builder().add(CouchFeature.ALLOW_DB_DELETE, (Object)true).build();
            CouchDatabase masterDatabaseForDelete = masterServer.database(serversConfig.getMasterDatabaseName(), featureSet);
            masterDatabaseForDelete.deleteDatabase();
        }
        if (!(localMasterDatabase = masterServer.database(serversConfig.getMasterDatabaseName())).exists()) {
            String[] designNames;
            localMasterDatabase.createDatabase();
            for (String designName : designNames = new String[]{"DomainProfile", "Entity"}) {
                String designPath = String.format("/couch/%s-design.json", designName);
                InputStream designStream = this.getClass().getResourceAsStream(designPath);
                if (designStream == null) {
                    String msg = String.format("Unable to find couch design file at: %s", designPath);
                    throw ApiException.internalServerError((String)msg, (String[])new String[0]);
                }
                try {
                    String designContent = IoUtils.toString((InputStream)designStream);
                    WriteResponse response = localMasterDatabase.put().design(designName, designContent).execute();
                    if (!response.isError()) continue;
                    String msg = String.format("Error creating views %s - %s", response.getHttpStatus(), response.getErrorReason());
                    throw ApiException.internalServerError((String)msg, (String[])new String[0]);
                }
                catch (IOException ex) {
                    String msg = "Error reading design file: " + designPath;
                    throw ApiException.internalServerError((Throwable)ex, (String[])new String[]{msg});
                }
            }
        }
        return localMasterDatabase;
    }

    public void deleteDomainDatabases(String domainName) {
        String requestDbName;
        CouchDatabase requestDatabase;
        if (!this.isTestEnvironment()) {
            throw ApiException.badRequest((String)"Can only create databases in test environment", (String[])new String[0]);
        }
        CouchFeatureSet featureSet = CouchFeatureSet.builder().add(CouchFeature.ALLOW_DB_DELETE, (Object)true).build();
        String notificationDbName = this.buildNotificationDbName(domainName);
        CouchDatabase notificationDatabase = this.notificationServer.database(notificationDbName, featureSet);
        if (notificationDatabase.exists()) {
            notificationDatabase.deleteDatabase();
        }
        if ((requestDatabase = this.requestServer.database(requestDbName = this.buildRequestDbName(domainName), featureSet)).exists()) {
            requestDatabase.deleteDatabase();
        }
    }

    public String buildDbName(String domainName, String defaultPrefix, String prefix, String suffix) {
        if (StringUtil.isNotBlank((String)prefix) && StringUtil.isNotBlank((String)suffix)) {
            return prefix + domainName + suffix;
        }
        if (StringUtil.isNotBlank((String)prefix)) {
            return prefix + domainName;
        }
        if (StringUtil.isNotBlank((String)suffix)) {
            return domainName + suffix;
        }
        return defaultPrefix + domainName;
    }

    public String buildRequestDbName(String domainName) {
        String prefix = this.requestDatabasePrefix;
        String suffix = this.requestDatabaseSuffix;
        if (StringUtil.isNotBlank((String)prefix) && StringUtil.isNotBlank((String)suffix)) {
            return prefix + domainName + suffix;
        }
        if (StringUtil.isNotBlank((String)prefix)) {
            return prefix + domainName;
        }
        if (StringUtil.isNotBlank((String)suffix)) {
            return domainName + suffix;
        }
        return domainName + "-notify-request";
    }

    public String buildNotificationDbName(String domainName) {
        String prefix = this.notificationDatabasePrefix;
        String suffix = this.notificationDatabaseSuffix;
        if (StringUtil.isNotBlank((String)prefix) && StringUtil.isNotBlank((String)suffix)) {
            return prefix + domainName + suffix;
        }
        if (StringUtil.isNotBlank((String)prefix)) {
            return prefix + domainName;
        }
        if (StringUtil.isNotBlank((String)suffix)) {
            return domainName + suffix;
        }
        return domainName + "-notify";
    }

    public boolean isTestEnvironment() {
        return this.environment.acceptsProfiles(new String[]{"test"}) && !this.environment.acceptsProfiles(new String[]{"hosted"});
    }

    public CouchServersConfig getServersConfig() {
        return this.serversConfig;
    }

    public CouchServer getMasterServer() {
        return this.masterServer;
    }

    public CouchDatabase getMasterDatabase() {
        return this.masterDatabase;
    }

    public CouchServer getNotificationServer() {
        return this.notificationServer;
    }

    public CouchServer getRequestServer() {
        return this.requestServer;
    }

    public String getNotificationDatabasePrefix() {
        return this.notificationDatabasePrefix;
    }

    public String getNotificationDatabaseSuffix() {
        return this.notificationDatabaseSuffix;
    }

    public String getRequestDatabasePrefix() {
        return this.requestDatabasePrefix;
    }

    public String getRequestDatabaseSuffix() {
        return this.requestDatabaseSuffix;
    }
}

