/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.query.CouchPageNavigation;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.GetResponse;
import org.tiogasolutions.couchace.core.api.response.TextDocument;

public class GetDocumentResponse
extends GetResponse
implements Iterable<TextDocument> {
    private final CouchPageNavigation couchPageNavigation;
    private final List<TextDocument> documentList;

    public static GetDocumentResponse withError(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, CouchErrorContent errorContent) {
        return new GetDocumentResponse(uri, statusCode, contentType, errorContent);
    }

    public static GetDocumentResponse withDocument(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, TextDocument document) {
        return new GetDocumentResponse(uri, statusCode, contentType, null, Collections.singletonList(document));
    }

    public static GetDocumentResponse withDocuments(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, List<TextDocument> documents) {
        return new GetDocumentResponse(uri, statusCode, contentType, null, documents);
    }

    public static GetDocumentResponse withDocuments(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, CouchPageNavigation couchPageNavigation, List<TextDocument> documents) {
        return new GetDocumentResponse(uri, statusCode, contentType, couchPageNavigation, documents);
    }

    private GetDocumentResponse(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, CouchErrorContent errorContent) {
        super(uri, statusCode, contentType, errorContent);
        this.couchPageNavigation = CouchPageNavigation.empty();
        this.documentList = Collections.emptyList();
    }

    private GetDocumentResponse(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, CouchPageNavigation couchPageNavigation, List<TextDocument> documentList) {
        super(uri, statusCode, contentType, null);
        this.couchPageNavigation = couchPageNavigation;
        this.documentList = documentList == null ? Collections.emptyList() : Collections.unmodifiableList(documentList);
    }

    public List<TextDocument> getDocumentList() {
        return this.documentList;
    }

    public int getDocumentCount() {
        return this.documentList.size();
    }

    public boolean isEmpty() {
        return this.getDocumentList().isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.getDocumentList().isEmpty();
    }

    public int getSize() {
        return this.getDocumentList().size();
    }

    public TextDocument getFirstDocument() {
        return this.getDocumentList().get(0);
    }

    public CouchPageNavigation getCouchPageNavigation() {
        return this.couchPageNavigation;
    }

    public Long getFirstContentAsLong() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.getFirstDocument().getContentAsLong();
    }

    @Override
    public Iterator<TextDocument> iterator() {
        return this.documentList.iterator();
    }
}

