/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.query.CouchPageNavigation;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.EntityDocument;
import org.tiogasolutions.couchace.core.api.response.GetResponse;

public class GetEntityResponse<T>
extends GetResponse
implements Iterable<T> {
    private final Class<?> entityClass;
    private final List<T> entityList;
    private final List<EntityDocument<T>> entityDocumentList;
    private final CouchPageNavigation couchPageNavigation;

    public static <T> GetEntityResponse<T> withError(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Class<T> entityClass, CouchErrorContent errorContent) {
        return new GetEntityResponse<T>(uri, statusCode, contentType, entityClass, errorContent);
    }

    public static <T> GetEntityResponse<T> withEntity(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Class<T> entityClass, EntityDocument<T> entity) {
        return new GetEntityResponse<T>(uri, statusCode, contentType, entityClass, null, Collections.singletonList(entity));
    }

    public static <T> GetEntityResponse<T> withEntities(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Class<T> entityClass, List<EntityDocument<T>> entities) {
        return new GetEntityResponse<T>(uri, statusCode, contentType, entityClass, null, entities);
    }

    public static <T> GetEntityResponse<T> withEntities(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Class<T> entityClass, CouchPageNavigation couchPageNavigation, List<EntityDocument<T>> entities) {
        return new GetEntityResponse<T>(uri, statusCode, contentType, entityClass, couchPageNavigation, entities);
    }

    private GetEntityResponse(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Class<T> entityClass, CouchPageNavigation couchPageNavigation, List<EntityDocument<T>> entityDocuments) {
        super(uri, statusCode, contentType, null);
        Class<Object> clazz = this.entityClass = entityClass != null ? entityClass : Object.class;
        if (entityDocuments == null) {
            this.entityDocumentList = Collections.emptyList();
            this.entityList = Collections.emptyList();
        } else {
            this.entityDocumentList = Collections.unmodifiableList(entityDocuments);
            ArrayList<T> localEntityList = new ArrayList<T>();
            for (EntityDocument<T> entityDocument : this.entityDocumentList) {
                localEntityList.add(entityDocument.getEntity());
            }
            this.entityList = Collections.unmodifiableList(localEntityList);
        }
        this.couchPageNavigation = couchPageNavigation;
    }

    private GetEntityResponse(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Class<T> entityClass, CouchErrorContent errorContent) {
        super(uri, statusCode, contentType, errorContent);
        this.entityClass = entityClass != null ? entityClass : Object.class;
        this.entityDocumentList = Collections.emptyList();
        this.entityList = Collections.emptyList();
        this.couchPageNavigation = CouchPageNavigation.empty();
    }

    public List<EntityDocument<T>> getDocumentList() {
        return this.entityDocumentList;
    }

    @Override
    public Iterator<T> iterator() {
        return this.entityList.iterator();
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public T getFirstEntity() {
        if (this.entityList.size() == 0) {
            throw new IllegalStateException("Attempting to get firstEntity from empty GetEntityResponse.");
        }
        return this.entityList.get(0);
    }

    public List<T> getEntityList() {
        return this.entityList;
    }

    public boolean isEmpty() {
        return this.getDocumentList().isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.getDocumentList().isEmpty();
    }

    public int getSize() {
        return this.getDocumentList().size();
    }

    public EntityDocument<T> getFirstDocument() {
        return this.getDocumentList().get(0);
    }

    public CouchPageNavigation getCouchPageNavigation() {
        return this.couchPageNavigation;
    }
}

