/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.glassfish.grizzly.utils.ArrayUtils;

public class ArraySet<T>
implements Set<T> {
    private volatile T[] array;
    private final Object sync = new Object();
    private final Class<T> clazz;
    private final boolean replaceElementIfEquals;

    public ArraySet(Class<T> clazz) {
        this(clazz, true);
    }

    public ArraySet(Class<T> clazz, boolean replaceElementIfEquals) {
        this.clazz = clazz;
        this.replaceElementIfEquals = replaceElementIfEquals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addAll(T ... elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            int startIdx = 0;
            if (this.array == null) {
                this.array = (Object[])Array.newInstance(this.clazz, 1);
                this.array[0] = elements[0];
                startIdx = 1;
            }
            boolean result = false;
            for (int i = startIdx; i < elements.length; ++i) {
                T element = elements[i];
                T[] oldArray = this.array;
                this.array = ArrayUtils.addUnique(this.array, element, this.replaceElementIfEquals);
                result |= oldArray != this.array;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            boolean initArray;
            boolean bl = initArray = this.array == null;
            if (initArray) {
                this.array = (Object[])Array.newInstance(this.clazz, 1);
            }
            boolean result = false;
            for (T element : collection) {
                if (initArray) {
                    initArray = false;
                    this.array[0] = element;
                    continue;
                }
                T[] oldArray = this.array;
                this.array = ArrayUtils.addUnique(this.array, element, this.replaceElementIfEquals);
                result |= oldArray != this.array;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean add(ArraySet<T> source) {
        T[] sourceArraySet = source.getArray();
        if (sourceArraySet == null) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.array == null) {
                this.array = Arrays.copyOf(sourceArraySet, sourceArraySet.length);
                return true;
            }
            boolean result = false;
            for (int i = 0; i < sourceArraySet.length; ++i) {
                T element = sourceArraySet[i];
                T[] oldArray = this.array;
                this.array = ArrayUtils.addUnique(this.array, element, this.replaceElementIfEquals);
                result |= oldArray != this.array;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeAll(Object ... elements) {
        if (elements.length == 0) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.array == null) {
                return false;
            }
            boolean result = false;
            for (Object element : elements) {
                T[] oldArray = this.array;
                this.array = ArrayUtils.remove(this.array, element);
                result |= oldArray != this.array;
            }
            return result;
        }
    }

    public final T[] getArray() {
        return this.array;
    }

    public final T[] getArrayCopy() {
        T[] localArray = this.array;
        if (localArray == null) {
            return null;
        }
        return Arrays.copyOf(localArray, localArray.length);
    }

    public final T[] obtainArrayCopy() {
        T[] localArray = this.array;
        if (localArray == null) {
            return (Object[])Array.newInstance(this.clazz, 0);
        }
        return Arrays.copyOf(localArray, localArray.length);
    }

    @Override
    public void clear() {
        this.array = null;
    }

    @Override
    public int size() {
        T[] localArray = this.array;
        return localArray != null ? localArray.length : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.array == null) {
                this.array = (Object[])Array.newInstance(this.clazz, 1);
                this.array[0] = element;
                return true;
            }
            T[] oldArray = this.array;
            this.array = ArrayUtils.addUnique(this.array, element, this.replaceElementIfEquals);
            return oldArray != this.array;
        }
    }

    @Override
    public boolean contains(Object o) {
        T[] localArray = this.array;
        if (localArray == null) {
            return false;
        }
        for (int i = 0; i < localArray.length; ++i) {
            if (!localArray[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        T[] localArray = this.array;
        return Arrays.copyOf(localArray, localArray.length);
    }

    @Override
    public <K> K[] toArray(K[] a) {
        T[] localArray = this.array;
        if (localArray == null) {
            return a;
        }
        int size = localArray.length;
        if (a.length < size) {
            return Arrays.copyOf(localArray, size, a.getClass());
        }
        System.arraycopy(localArray, 0, a, 0, localArray.length);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeAll(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        T[] localArray = this.array;
        for (Object element : collection) {
            if (ArrayUtils.indexOf(localArray, element) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        T[] localArray = this.array;
        if (localArray == null) {
            return false;
        }
        Object[] newArray = (Object[])Array.newInstance(this.clazz, Math.min(localArray.length, collection.size()));
        int newSize = 0;
        for (int i = 0; i < localArray.length; ++i) {
            T elem = localArray[i];
            if (!collection.contains(elem)) continue;
            newArray[newSize++] = elem;
        }
        if (newSize == localArray.length) {
            return false;
        }
        this.array = Arrays.copyOf(newArray, newSize);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        T[] localArray = this.array;
        if (localArray == null) {
            return false;
        }
        Object[] newArray = (Object[])Array.newInstance(this.clazz, localArray.length);
        int newSize = 0;
        for (int i = 0; i < localArray.length; ++i) {
            T elem = localArray[i];
            if (collection.contains(elem)) continue;
            newArray[newSize++] = elem;
        }
        if (newSize == localArray.length) {
            return false;
        }
        this.array = Arrays.copyOf(newArray, newSize);
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<T> {
        int cursor;
        T lastRet;
        T nextElem;

        public Itr() {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextElem != null;
        }

        @Override
        public T next() {
            if (this.nextElem == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.nextElem;
            this.advance();
            return this.lastRet;
        }

        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            ArraySet.this.remove(this.lastRet);
            --this.cursor;
            this.lastRet = null;
        }

        private void advance() {
            Object[] localArray = ArraySet.this.array;
            if (localArray == null || this.cursor >= localArray.length) {
                this.nextElem = null;
                return;
            }
            this.nextElem = localArray[this.cursor++];
        }
    }
}

