/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common;

import org.tiogasolutions.dev.common.OperatingSystem;

public class OsUtils {
    private OsUtils() {
    }

    public static OperatingSystem getOperatingSystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OperatingSystem.Windows;
        }
        if (osName.contains("mac")) {
            return OperatingSystem.Mac;
        }
        return OperatingSystem.Unknown;
    }

    public static boolean isMac() {
        return OsUtils.getOperatingSystem().isMac();
    }

    public static boolean isWindows() {
        return OsUtils.getOperatingSystem().isWindows();
    }

    public static boolean isUnknown() {
        return OsUtils.getOperatingSystem().isUnknown();
    }
}

