/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;

public abstract class TiogaJaxRsExceptionMapper
implements ExceptionMapper<Throwable> {
    @Context
    protected UriInfo uriInfo;
    private final boolean renderAsJson;
    private final Map<String, Integer> exceptionMap = new HashMap<String, Integer>();
    private static final String JSON_TEMPLATE = "{\n  \"status\" : \"%s\",\n  \"message\" : \"%s\"\n}";

    protected abstract void logInfo(String var1, Throwable var2);

    protected abstract void logError(String var1, Throwable var2);

    public TiogaJaxRsExceptionMapper(boolean renderAsJson) {
        this.renderAsJson = renderAsJson;
        this.logInfo("Created exception mapper", null);
    }

    public Response toResponse(Throwable ex) {
        WebApplicationException wae;
        String exceptionName = ex.getClass().getName();
        if (this.exceptionMap.containsKey(exceptionName)) {
            int status = this.exceptionMap.get(exceptionName);
            return this.createResponse(status, ex);
        }
        if (ex instanceof ApiException) {
            ApiException apiEx = (ApiException)ex;
            int status = apiEx.getHttpStatusCode().getCode();
            return this.createResponse(status, ex);
        }
        if (ex instanceof WebApplicationException && (wae = (WebApplicationException)ex).getResponse() != null) {
            int status = wae.getResponse().getStatus();
            return this.createResponse(status, ex);
        }
        return this.createResponse(500, ex);
    }

    protected void logException(Throwable throwable, int status) {
        String msg = "Status " + status;
        if (this.uriInfo != null) {
            msg = msg + " ";
            msg = msg + this.uriInfo.getRequestUri();
        }
        if (status >= 400 && status < 500) {
            this.logInfo(msg, throwable);
        } else {
            this.logError(msg, throwable);
        }
    }

    protected Response createResponse(int status, Throwable ex) {
        this.logException(ex, status);
        String message = ExceptionUtils.getMessage((Throwable)ex);
        if (this.renderAsJson) {
            message = message.replace("\\", "\\\\");
            message = message.replace("\"", "\\\"");
            String json = String.format(JSON_TEMPLATE, status, message);
            return Response.status((int)status).entity((Object)json).type("application/json").build();
        }
        return Response.status((int)status).entity((Object)message).type("text/plain").build();
    }
}

