/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import org.tiogasolutions.dev.common.fine.FineMessage;
import org.tiogasolutions.dev.common.fine.FineMessageSet;
import org.tiogasolutions.dev.common.fine.TraitMap;
import org.tiogasolutions.dev.domain.account.AccountStatus;
import org.tiogasolutions.dev.domain.locality.LatLng;
import org.tiogasolutions.dev.domain.money.Money;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.dev.jackson.mixins.AccountStatusMixin;
import org.tiogasolutions.dev.jackson.mixins.LatLngMixin;
import org.tiogasolutions.dev.jackson.money.TiogaMoneyDeserializer;
import org.tiogasolutions.dev.jackson.money.TiogaMoneySerializer;
import org.tiogasolutions.dev.jackson.msg.FineMessageMixin;
import org.tiogasolutions.dev.jackson.msg.FineMessageSetDeserializer;
import org.tiogasolutions.dev.jackson.msg.FineMessageSetSerializer;
import org.tiogasolutions.dev.jackson.qry.QueryResultDeserializer;
import org.tiogasolutions.dev.jackson.qry.QueryResultSerializer;
import org.tiogasolutions.dev.jackson.time.LocalDateDeserializer;
import org.tiogasolutions.dev.jackson.time.LocalDateSerializer;
import org.tiogasolutions.dev.jackson.time.LocalDateTimeDeserializer;
import org.tiogasolutions.dev.jackson.time.LocalDateTimeSerializer;
import org.tiogasolutions.dev.jackson.time.LocalTimeDeserializer;
import org.tiogasolutions.dev.jackson.time.LocalTimeSerializer;
import org.tiogasolutions.dev.jackson.time.ZonedDateTimeDeserializer;
import org.tiogasolutions.dev.jackson.time.ZonedDateTimeSerializer;
import org.tiogasolutions.dev.jackson.trait.TraitMapDeserializer;
import org.tiogasolutions.dev.jackson.trait.TraitMapSerializer;

public class TiogaJacksonModule
extends SimpleModule {
    public TiogaJacksonModule() {
        this.add(Money.class, (JsonSerializer)new TiogaMoneySerializer(), (JsonDeserializer)new TiogaMoneyDeserializer());
        this.add(TraitMap.class, (JsonSerializer)new TraitMapSerializer(), (JsonDeserializer)new TraitMapDeserializer());
        this.add(FineMessageSet.class, (JsonSerializer)new FineMessageSetSerializer(), (JsonDeserializer)new FineMessageSetDeserializer());
        this.add(QueryResult.class, (JsonSerializer)new QueryResultSerializer(), (JsonDeserializer)new QueryResultDeserializer());
        this.add(LocalDate.class, (JsonSerializer)new LocalDateSerializer(), (JsonDeserializer)new LocalDateDeserializer());
        this.add(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(), (JsonDeserializer)new LocalTimeDeserializer());
        this.add(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(), (JsonDeserializer)new LocalDateTimeDeserializer());
        this.add(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer(), (JsonDeserializer)new ZonedDateTimeDeserializer());
        this.setMixInAnnotation(LatLng.class, LatLngMixin.class);
        this.setMixInAnnotation(FineMessage.class, FineMessageMixin.class);
        this.setMixInAnnotation(AccountStatus.class, AccountStatusMixin.class);
        this.add("org.joda.money.Money", "org.tiogasolutions.lib.joda.jackson.JodaMoneySerializer", "org.tiogasolutions.lib.joda.jackson.JodaMoneyDeserializer");
        this.add("org.joda.time.DateMidnight", "com.fasterxml.jackson.datatype.joda.ser.DateMidnightSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateMidnightDeserializer");
        this.add("org.joda.time.DateTime", "com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateTimeDeserializer");
        this.add("org.joda.time.DateTimeZone", "com.fasterxml.jackson.datatype.joda.ser.DateTimeZoneSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateTimeZoneDeserializer");
        this.add("org.joda.time.Duration", "com.fasterxml.jackson.datatype.joda.ser.DurationSerializer", "com.fasterxml.jackson.datatype.joda.deser.DurationDeserializer");
        this.add("org.joda.time.Instant", "com.fasterxml.jackson.datatype.joda.ser.InstantSerializer", "com.fasterxml.jackson.datatype.joda.deser.InstantDeserializer");
        this.add("org.joda.time.LocalDateTime", "com.fasterxml.jackson.datatype.joda.ser.LocalDateTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalDateTimeDeserializer");
        this.add("org.joda.time.LocalDate", "com.fasterxml.jackson.datatype.joda.ser.LocalDateSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalDateDeserializer");
        this.add("org.joda.time.LocalTime", "com.fasterxml.jackson.datatype.joda.ser.LocalTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalTimeDeserializer");
        this.add("org.joda.time.Period", "com.fasterxml.jackson.datatype.joda.ser.PeriodSerializer", "com.fasterxml.jackson.datatype.joda.deser.PeriodDeserializer");
        this.add("org.joda.time.Interval", "com.fasterxml.jackson.datatype.joda.ser.IntervalSerializer", "com.fasterxml.jackson.datatype.joda.deser.IntervalDeserializer");
        this.add("org.joda.time.MonthDay", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", "com.fasterxml.jackson.datatype.joda.deser.MonthDayDeserializer");
        this.add("org.joda.time.YearMonth", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", "com.fasterxml.jackson.datatype.joda.deser.YearMonthDeserializer");
    }

    private void add(Class type, JsonSerializer serializer, JsonDeserializer deserializer) {
        this.addSerializer(type, serializer);
        this.addDeserializer(type, deserializer);
    }

    private void add(String typeName, String serializerClassName, String deserializerClassName) {
        try {
            Class<?> type = Class.forName(typeName);
            Class<?> jsonSerializerClass = Class.forName(serializerClassName);
            JsonSerializer serializer = (JsonSerializer)jsonSerializerClass.newInstance();
            this.addSerializer(type, serializer);
            Class<?> jsonDeserializerClass = Class.forName(deserializerClassName);
            if (deserializerClassName.equals("com.fasterxml.jackson.datatype.joda.deser.DateTimeDeserializer")) {
                Class<?> dateTimeType = Class.forName("org.joda.time.DateTime");
                Constructor<?> constructor = jsonDeserializerClass.getConstructor(Class.class);
                JsonDeserializer deserializer = (JsonDeserializer)constructor.newInstance(dateTimeType);
                this.addDeserializer(type, deserializer);
            } else {
                JsonDeserializer deserializer = (JsonDeserializer)jsonDeserializerClass.newInstance();
                this.addDeserializer(type, deserializer);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
            // empty catch block
        }
    }
}

