/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.app.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.tiogasolutions.dev.common.EnvUtils;

public abstract class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);

    public static void initLogback(Level level) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        String pattern = "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";
        ple.setPattern(pattern);
        ple.setContext((Context)context);
        ple.start();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("STDOUT");
        appender.setContext((Context)context);
        appender.setEncoder((Encoder)ple);
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(level);
        root.addAppender((Appender)appender);
        log.info("Using default logback config: {} ({})", (Object)level, (Object)pattern);
    }

    public static Path initLogback(Path configDir, String propertyName, String fileName) {
        LogUtils.initLogback(Level.WARN);
        if (configDir == null) {
            log.info("Config directory not specified, using default logback config.");
            return null;
        }
        if (!Files.exists(configDir, new LinkOption[0])) {
            log.info("Config directory ({}) does not exist, using default logback config.", (Object)configDir);
            return null;
        }
        String logConfigArg = EnvUtils.findProperty((String)propertyName, (String)fileName);
        Path logConfigFile = configDir.resolve(logConfigArg);
        if (Files.notExists(logConfigFile, new LinkOption[0])) {
            log.info("Missing {}, using default logback config.", (Object)logConfigFile.toString());
            return null;
        }
        log.info("Configured logging from  {}", (Object)logConfigFile.toString());
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logConfigFile.toString());
        }
        catch (JoranException ignored) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        return logConfigFile;
    }
}

