/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import ch.qos.logback.classic.Level;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.app.common.AppPathResolver;
import org.tiogasolutions.app.common.LogUtils;
import org.tiogasolutions.notify.engine.web.NotifyApplication;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.runners.grizzlyspring.ApplicationResolver;
import org.tiogasolutions.runners.grizzlyspring.GrizzlySpringServer;
import org.tiogasolutions.runners.grizzlyspring.ServerConfigResolver;

public class NotifyServer {
    private static final Logger log = LoggerFactory.getLogger(NotifyServer.class);

    public static void main(String ... args) throws Exception {
        List<String> arguments = Arrays.asList(args);
        LogUtils.initLogback((Level)Level.WARN);
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger(NotifyServer.class)).setLevel(Level.INFO);
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger(GrizzlyServer.class)).setLevel(Level.INFO);
        AppPathResolver resolver = new AppPathResolver(arg_0 -> ((Logger)LoggerFactory.getLogger(AppPathResolver.class)).info(arg_0), "notify.");
        Path runtimeDir = resolver.resolveRuntimePath();
        Path configDir = resolver.resolveConfigDir(runtimeDir);
        Path logbackFile = LogUtils.initLogback((Path)configDir, (String)"notify.log.config", (String)"logback.xml");
        String springConfigPath = resolver.resolveSpringPath(configDir, null);
        String activeProfiles = resolver.resolveSpringProfiles();
        log.info("Starting Notify Server:\n  *  Runtime Dir:  {}\n  *  Config Dir:   {}\n  *  Logback File: {}\n  *  Spring Path:  {}", new Object[]{runtimeDir, configDir, logbackFile, springConfigPath});
        GrizzlySpringServer grizzlyServer = new GrizzlySpringServer(ServerConfigResolver.fromClass(GrizzlyServerConfig.class), ApplicationResolver.fromClass(NotifyApplication.class), activeProfiles, springConfigPath);
        grizzlyServer.packages(new String[]{"org.tiogasolutions.notify"});
        if (arguments.contains("-shutdown")) {
            GrizzlyServer.shutdownRemote((GrizzlyServerConfig)grizzlyServer.getConfig());
            log.warn("Shutting down Notify Server at {}:{}", (Object)grizzlyServer.getConfig().getHostName(), (Object)grizzlyServer.getConfig().getShutdownPort());
            System.exit(0);
            return;
        }
        grizzlyServer.start();
    }
}

