/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.runners.grizzly;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.grizzly.http.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.runners.grizzly.GrizzlyServer;
import org.tiogasolutions.runners.grizzly.GrizzlyServerConfig;

public class ShutdownHandler {
    private static final Logger log = LoggerFactory.getLogger(GrizzlyServer.class);
    private static final int socketAcceptTimeoutMilli = 5000;
    private ServerSocket socket;
    private Thread acceptThread;
    private HttpServer httpServer;
    private final GrizzlyServerConfig config;
    private final ReentrantLock handlerLock = new ReentrantLock();

    public ShutdownHandler(GrizzlyServerConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(HttpServer httpServer) throws TimeoutException, InterruptedException {
        this.httpServer = httpServer;
        this.lockHandler();
        if (this.acceptThread != null) {
            throw new IllegalStateException("Socket handler thread is already running.");
        }
        try {
            this.socket = new ServerSocket(this.config.getShutdownPort());
            this.socket.setSoTimeout(5000);
            try {
                Thread shutdownThread = new Thread(() -> ((HttpServer)httpServer).shutdown(), "shutdownHook");
                Runtime.getRuntime().addShutdownHook(shutdownThread);
                this.acceptThread = new Thread(this::socketAcceptLoop);
                this.acceptThread.start();
                String msg = String.format("%s is accepting connections on port %s from %s.", this.getClass().getSimpleName(), this.config.getShutdownPort(), this.socket.getInetAddress().getHostAddress());
                log.info(msg);
            }
            finally {
                this.unlockHandler();
            }
        }
        catch (IOException ex) {
            String msg = String.format("IOException starting server socket, maybe port %s was not available.", this.config.getPort());
            log.error(msg, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void socketAcceptLoop() {
        block7: while (!Thread.interrupted()) {
            try {
                Thread.sleep(5L);
                this.lockHandler();
                if (this.acceptThread == null || Thread.interrupted()) {
                    log.info("Looks like SocketHandler has been stopped, terminate our acceptLoop.");
                    System.out.println("Looks like SocketHandler has been stopped, terminate our acceptLoop.");
                    return;
                }
                Socket client = this.socket.accept();
                StringBuilder builder = new StringBuilder();
                InputStream is = client.getInputStream();
                while (true) {
                    int val;
                    if ((val = is.read()) == -1) continue block7;
                    builder.append((char)val);
                    if (!"SHUTDOWN".equals(builder.toString())) continue;
                    log.info("Shutdown command received.");
                    System.out.println("Shutdown command received.");
                    this.httpServer.shutdownNow();
                    System.exit(0);
                }
            }
            catch (SocketTimeoutException | TimeoutException ex) {
            }
            catch (Throwable ex) {
                log.error("Unexpected exception", ex);
                System.out.println("Unexpected exception");
                ex.printStackTrace();
                return;
            }
            finally {
                this.unlockHandler();
            }
        }
    }

    protected void unlockHandler() {
        this.handlerLock.unlock();
    }

    protected void lockHandler() throws TimeoutException, InterruptedException {
        int timeout = 5;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if (!this.handlerLock.tryLock(timeout, timeUnit)) {
            String msg = String.format("Failed to obtain lock within %s %s", new Object[]{timeout, timeUnit});
            throw new TimeoutException(msg);
        }
    }
}

